/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.Nulls;
import zz.com.fasterxml.jackson.core.JsonParseException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.io.NumberInput;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.KeyDeserializer;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyMetadata;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import zz.com.fasterxml.jackson.databind.deser.NullValueProvider;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import zz.com.fasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import zz.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import zz.com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import zz.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.util.AccessPattern;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.Converter;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    protected static final int F_MASK_ACCEPT_ARRAYS = DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS.getMask() | DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT.getMask();
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> clazz) {
        this._valueClass = clazz;
    }

    protected StdDeserializer(JavaType javaType) {
        this._valueClass = javaType == null ? Object.class : javaType.getRawClass();
    }

    protected StdDeserializer(StdDeserializer<?> stdDeserializer) {
        this._valueClass = stdDeserializer._valueClass;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return ClassUtil.isJacksonStdImpl(keyDeserializer);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            this._verifyNullForPrimitive(deserializationContext);
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string) || "True".equals(string)) {
                return true;
            }
            if ("false".equals(string) || "False".equals(string)) {
                return false;
            }
            if (this._isEmptyOrTextualNull(string)) {
                this._verifyNullForPrimitiveCoercion(deserializationContext, string);
                return false;
            }
            Boolean bl2 = (Boolean)deserializationContext.handleWeirdStringValue(this._valueClass, string, "only \"true\" or \"false\" recognized", new Object[0]);
            return Boolean.TRUE.equals(bl2);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            boolean bl3 = this._parseBooleanPrimitive(jsonParser, deserializationContext);
            this._verifyEndArrayForSingle(jsonParser, deserializationContext);
            return bl3;
        }
        return (Boolean)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected boolean _parseBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        this._verifyNumberForScalarCoercion(deserializationContext, jsonParser);
        return !"0".equals(jsonParser.getText());
    }

    protected final byte _parseBytePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
        if (this._byteOverflow(n2)) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, String.valueOf(n2), "overflow, value cannot be represented as 8-bit value", new Object[0]);
            return this._nonNullNumber(number).byteValue();
        }
        return (byte)n2;
    }

    protected final short _parseShortPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
        if (this._shortOverflow(n2)) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, String.valueOf(n2), "overflow, value cannot be represented as 16-bit value", new Object[0]);
            return this._nonNullNumber(number).shortValue();
        }
        return (short)n2;
    }

    protected final int _parseIntPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return jsonParser.getIntValue();
        }
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                String string = jsonParser.getText().trim();
                if (this._isEmptyOrTextualNull(string)) {
                    this._verifyNullForPrimitiveCoercion(deserializationContext, string);
                    return 0;
                }
                return this._parseIntPrimitive(deserializationContext, string);
            }
            case 8: {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "int");
                }
                return jsonParser.getValueAsInt();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0;
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return n2;
            }
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).intValue();
    }

    protected final int _parseIntPrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            if (string.length() > 9) {
                long l2 = Long.parseLong(string);
                if (this._intOverflow(l2)) {
                    Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "Overflow: numeric value (%s) out of range of int (%d -%d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    return this._nonNullNumber(number).intValue();
                }
                return (int)l2;
            }
            return NumberInput.parseInt(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid int value", new Object[0]);
            return this._nonNullNumber(number).intValue();
        }
    }

    protected final long _parseLongPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return jsonParser.getLongValue();
        }
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                String string = jsonParser.getText().trim();
                if (this._isEmptyOrTextualNull(string)) {
                    this._verifyNullForPrimitiveCoercion(deserializationContext, string);
                    return 0L;
                }
                return this._parseLongPrimitive(deserializationContext, string);
            }
            case 8: {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "long");
                }
                return jsonParser.getValueAsLong();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0L;
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                long l2 = this._parseLongPrimitive(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return l2;
            }
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).longValue();
    }

    protected final long _parseLongPrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        try {
            return NumberInput.parseLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid long value", new Object[0]);
            return this._nonNullNumber(number).longValue();
        }
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return jsonParser.getFloatValue();
        }
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                String string = jsonParser.getText().trim();
                if (this._isEmptyOrTextualNull(string)) {
                    this._verifyNullForPrimitiveCoercion(deserializationContext, string);
                    return 0.0f;
                }
                return this._parseFloatPrimitive(deserializationContext, string);
            }
            case 7: {
                return jsonParser.getFloatValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0.0f;
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return f2;
            }
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).floatValue();
    }

    protected final float _parseFloatPrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        switch (string.charAt(0)) {
            case 'I': {
                if (!this._isPosInf(string)) break;
                return Float.POSITIVE_INFINITY;
            }
            case 'N': {
                if (!this._isNaN(string)) break;
                return Float.NaN;
            }
            case '-': {
                if (!this._isNegInf(string)) break;
                return Float.NEGATIVE_INFINITY;
            }
        }
        try {
            return Float.parseFloat(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid float value", new Object[0]);
            return this._nonNullNumber(number).floatValue();
        }
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return jsonParser.getDoubleValue();
        }
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                String string = jsonParser.getText().trim();
                if (this._isEmptyOrTextualNull(string)) {
                    this._verifyNullForPrimitiveCoercion(deserializationContext, string);
                    return 0.0;
                }
                return this._parseDoublePrimitive(deserializationContext, string);
            }
            case 7: {
                return jsonParser.getDoubleValue();
            }
            case 11: {
                this._verifyNullForPrimitive(deserializationContext);
                return 0.0;
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return d2;
            }
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).doubleValue();
    }

    protected final double _parseDoublePrimitive(DeserializationContext deserializationContext, String string) throws IOException {
        switch (string.charAt(0)) {
            case 'I': {
                if (!this._isPosInf(string)) break;
                return Double.POSITIVE_INFINITY;
            }
            case 'N': {
                if (!this._isNaN(string)) break;
                return Double.NaN;
            }
            case '-': {
                if (!this._isNegInf(string)) break;
                return Double.NEGATIVE_INFINITY;
            }
        }
        try {
            return StdDeserializer.parseDouble(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid double value (as String to convert)", new Object[0]);
            return this._nonNullNumber(number).doubleValue();
        }
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 6: {
                return this._parseDate(jsonParser.getText().trim(), deserializationContext);
            }
            case 7: {
                long l2;
                try {
                    l2 = jsonParser.getLongValue();
                }
                catch (JsonParseException jsonParseException) {
                    Number number = (Number)deserializationContext.handleWeirdNumberValue(this._valueClass, jsonParser.getNumberValue(), "not a valid 64-bit long for creating `java.util.Date`", new Object[0]);
                    l2 = number.longValue();
                }
                return new Date(l2);
            }
            case 11: {
                return (Date)this.getNullValue(deserializationContext);
            }
            case 3: {
                return this._parseDateFromArray(jsonParser, deserializationContext);
            }
        }
        return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected Date _parseDateFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken;
        if (deserializationContext.hasSomeOfFeatures(F_MASK_ACCEPT_ARRAYS)) {
            jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                return (Date)this.getNullValue(deserializationContext);
            }
            if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                Date date = this._parseDate(jsonParser, deserializationContext);
                this._verifyEndArrayForSingle(jsonParser, deserializationContext);
                return date;
            }
        } else {
            jsonToken = jsonParser.getCurrentToken();
        }
        return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, jsonToken, jsonParser, null, new Object[0]);
    }

    protected Date _parseDate(String string, DeserializationContext deserializationContext) throws IOException {
        try {
            if (this._isEmptyOrTextualNull(string)) {
                return (Date)this.getNullValue(deserializationContext);
            }
            return deserializationContext.parseDate(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Date)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation (error: %s)", illegalArgumentException.getMessage());
        }
    }

    protected static final double parseDouble(String string) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(string)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(string);
    }

    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            return jsonParser.getText();
        }
        String string = jsonParser.getValueAsString();
        if (string != null) {
            return string;
        }
        return (String)deserializationContext.handleUnexpectedToken(String.class, jsonParser);
    }

    protected T _deserializeFromEmpty(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_ARRAY) {
            if (deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    return null;
                }
                return (T)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
            }
        } else if (jsonToken == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (string = jsonParser.getText().trim()).isEmpty()) {
            return null;
        }
        return (T)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected boolean _isEmptyOrTextualNull(String string) {
        return string.isEmpty() || "null".equals(string);
    }

    protected final boolean _isNegInf(String string) {
        return "-Infinity".equals(string) || "-INF".equals(string);
    }

    protected final boolean _isPosInf(String string) {
        return "Infinity".equals(string) || "INF".equals(string);
    }

    protected final boolean _isNaN(String string) {
        return "NaN".equals(string);
    }

    protected T _deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken;
        if (deserializationContext.hasSomeOfFeatures(F_MASK_ACCEPT_ARRAYS)) {
            jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                return this.getNullValue(deserializationContext);
            }
            if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                Object t2 = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return t2;
            }
        } else {
            jsonToken = jsonParser.getCurrentToken();
        }
        Object object = deserializationContext.handleUnexpectedToken(this._valueClass, jsonToken, jsonParser, null, new Object[0]);
        return (T)object;
    }

    protected T _deserializeWrappedValue(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            String string = String.format("Cannot deserialize instance of %s out of %s token: nested Arrays not allowed with %s", new Object[]{ClassUtil.nameOf(this._valueClass), JsonToken.START_ARRAY, "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS"});
            Object object = deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser.getCurrentToken(), jsonParser, string, new Object[0]);
            return (T)object;
        }
        return this.deserialize(jsonParser, deserializationContext);
    }

    protected void _failDoubleToIntCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        deserializationContext.reportInputMismatch(this.handledType(), "Cannot coerce a floating-point value ('%s') into %s (enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow)", jsonParser.getValueAsString(), string);
    }

    protected Object _coerceIntegral(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n2 = deserializationContext.getDeserializationFeatures();
        if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2)) {
            return jsonParser.getBigIntegerValue();
        }
        if (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n2)) {
            return jsonParser.getLongValue();
        }
        return jsonParser.getBigIntegerValue();
    }

    protected Object _coerceNullToken(DeserializationContext deserializationContext, boolean bl2) throws JsonMappingException {
        if (bl2) {
            this._verifyNullForPrimitive(deserializationContext);
        }
        return this.getNullValue(deserializationContext);
    }

    protected Object _coerceTextualNull(DeserializationContext deserializationContext, boolean bl2) throws JsonMappingException {
        boolean bl3;
        Enum enum_;
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl3 = true;
        } else if (bl2 && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl3 = false;
        } else {
            return this.getNullValue(deserializationContext);
        }
        this._reportFailedNullCoerce(deserializationContext, bl3, enum_, "String \"null\"");
        return null;
    }

    protected Object _coerceEmptyString(DeserializationContext deserializationContext, boolean bl2) throws JsonMappingException {
        boolean bl3;
        Enum enum_;
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl3 = true;
        } else if (bl2 && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl3 = false;
        } else {
            return this.getNullValue(deserializationContext);
        }
        this._reportFailedNullCoerce(deserializationContext, bl3, enum_, "empty String (\"\")");
        return null;
    }

    protected final void _verifyNullForPrimitive(DeserializationContext deserializationContext) throws JsonMappingException {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce `null` %s (disable `DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES` to allow)", this._coercedTypeDesc());
        }
    }

    protected final void _verifyNullForPrimitiveCoercion(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        boolean bl2;
        Enum enum_;
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            enum_ = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            bl2 = true;
        } else if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            enum_ = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            bl2 = false;
        } else {
            return;
        }
        String string2 = string.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", string);
        this._reportFailedNullCoerce(deserializationContext, bl2, enum_, string2);
    }

    protected final void _verifyNullForScalarCoercion(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            String string2 = string.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", string);
            this._reportFailedNullCoerce(deserializationContext, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, string2);
        }
    }

    protected void _verifyStringForScalarCoercion(DeserializationContext deserializationContext, String string) throws JsonMappingException {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!deserializationContext.isEnabled(mapperFeature)) {
            deserializationContext.reportInputMismatch(this, "Cannot coerce String \"%s\" %s (enable `%s.%s` to allow)", string, this._coercedTypeDesc(), mapperFeature.getClass().getSimpleName(), mapperFeature.name());
        }
    }

    protected void _verifyNumberForScalarCoercion(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        MapperFeature mapperFeature = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!deserializationContext.isEnabled(mapperFeature)) {
            String string = jsonParser.getText();
            deserializationContext.reportInputMismatch(this, "Cannot coerce Number (%s) %s (enable `%s.%s` to allow)", string, this._coercedTypeDesc(), mapperFeature.getClass().getSimpleName(), mapperFeature.name());
        }
    }

    protected void _reportFailedNullCoerce(DeserializationContext deserializationContext, boolean bl2, Enum<?> enum_, String string) throws JsonMappingException {
        String string2 = bl2 ? "enable" : "disable";
        deserializationContext.reportInputMismatch(this, "Cannot coerce %s to Null value %s (%s `%s.%s` to allow)", string, this._coercedTypeDesc(), string2, enum_.getClass().getSimpleName(), enum_.name());
    }

    protected String _coercedTypeDesc() {
        String string;
        boolean bl2;
        JavaType javaType = this.getValueType();
        if (javaType != null && !javaType.isPrimitive()) {
            bl2 = javaType.isContainerType() || javaType.isReferenceType();
            string = "'" + javaType.toString() + "'";
        } else {
            Class<?> clazz = this.handledType();
            bl2 = clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
            string = ClassUtil.nameOf(clazz);
        }
        if (bl2) {
            return "as content of type " + string;
        }
        return "for type " + string;
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    protected final boolean _isIntNumber(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            int n3;
            char c2 = string.charAt(0);
            int n4 = n3 = c2 == '-' || c2 == '+' ? 1 : 0;
            while (n3 < n2) {
                char c3 = string.charAt(n3);
                if (c3 > '9' || c3 < '0') {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (StdDeserializer._neitherNull(annotationIntrospector, beanProperty) && (annotatedMember = beanProperty.getMember()) != null && (object = annotationIntrospector.findDeserializationContentConverter(annotatedMember)) != null) {
            Converter<Object, Object> converter = deserializationContext.converterInstance(beanProperty.getMember(), object);
            JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
            return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(deserializationContext.getConfig(), clazz);
        }
        return deserializationContext.getDefaultPropertyFormat(clazz);
    }

    protected Boolean findFormatFeature(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, clazz);
        if (value != null) {
            return value.getFeature(feature);
        }
        return null;
    }

    protected final NullValueProvider findValueNullProvider(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty, PropertyMetadata propertyMetadata) throws JsonMappingException {
        if (settableBeanProperty != null) {
            return this._findNullProvider(deserializationContext, settableBeanProperty, propertyMetadata.getValueNulls(), settableBeanProperty.getValueDeserializer());
        }
        return null;
    }

    protected NullValueProvider findContentNullProvider(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Nulls nulls = this.findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        NullValueProvider nullValueProvider = this._findNullProvider(deserializationContext, beanProperty, nulls, jsonDeserializer);
        if (nullValueProvider != null) {
            return nullValueProvider;
        }
        return jsonDeserializer;
    }

    protected Nulls findContentNullStyle(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            return beanProperty.getMetadata().getContentNulls();
        }
        return null;
    }

    protected final NullValueProvider _findNullProvider(DeserializationContext deserializationContext, BeanProperty beanProperty, Nulls nulls, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (nulls == Nulls.FAIL) {
            if (beanProperty == null) {
                return NullsFailProvider.constructForRootValue(deserializationContext.constructType(jsonDeserializer.handledType()));
            }
            return NullsFailProvider.constructForProperty(beanProperty);
        }
        if (nulls == Nulls.AS_EMPTY) {
            Object object;
            if (jsonDeserializer == null) {
                return null;
            }
            if (jsonDeserializer instanceof BeanDeserializerBase && !((ValueInstantiator)(object = ((BeanDeserializerBase)jsonDeserializer).getValueInstantiator())).canCreateUsingDefault()) {
                JavaType javaType = beanProperty.getType();
                deserializationContext.reportBadDefinition(javaType, String.format("Cannot create empty instance of %s, no default Creator", javaType));
            }
            if ((object = jsonDeserializer.getEmptyAccessPattern()) == AccessPattern.ALWAYS_NULL) {
                return NullsConstantProvider.nuller();
            }
            if (object == AccessPattern.CONSTANT) {
                return NullsConstantProvider.forValue(jsonDeserializer.getEmptyValue(deserializationContext));
            }
            return new NullsAsEmptyProvider(jsonDeserializer);
        }
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        return null;
    }

    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object clazz, String string) throws IOException {
        if (clazz == null) {
            clazz = this.handledType();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, clazz, string)) {
            return;
        }
        jsonParser.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Attempted to unwrap '%s' value from an array (with `DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS`) but it contains more than one value", this.handledType().getName());
    }

    protected void _verifyEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != JsonToken.END_ARRAY) {
            this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
        }
    }

    protected static final boolean _neitherNull(Object object, Object object2) {
        return object != null && object2 != null;
    }

    protected final boolean _byteOverflow(int n2) {
        return n2 < -128 || n2 > 255;
    }

    protected final boolean _shortOverflow(int n2) {
        return n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE;
    }

    protected final boolean _intOverflow(long l2) {
        return l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE;
    }

    protected Number _nonNullNumber(Number number) {
        if (number == null) {
            number = 0;
        }
        return number;
    }
}

