/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import zz.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import zz.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import zz.com.fasterxml.jackson.databind.util.NameTransformer;

public class ThrowableDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final String PROP_NAME_MESSAGE = "message";

    public ThrowableDeserializer(BeanDeserializer beanDeserializer) {
        super(beanDeserializer);
        this._vanillaProcessing = false;
    }

    protected ThrowableDeserializer(BeanDeserializer beanDeserializer, NameTransformer nameTransformer) {
        super((BeanDeserializerBase)beanDeserializer, nameTransformer);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        return new ThrowableDeserializer(this, nameTransformer);
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._beanType.isAbstract()) {
            return deserializationContext.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), jsonParser, "abstract type (need to add/enable type information?)", new Object[0]);
        }
        boolean bl2 = this._valueInstantiator.canCreateFromString();
        boolean bl3 = this._valueInstantiator.canCreateUsingDefault();
        if (!bl2 && !bl3) {
            return deserializationContext.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), jsonParser, "Throwable needs a default contructor, a single-String-arg constructor; or explicit @JsonCreator", new Object[0]);
        }
        Object object = null;
        Object[] objectArray = null;
        int n2 = 0;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            int n3;
            String string = jsonParser.getCurrentName();
            SettableBeanProperty settableBeanProperty = this._beanProperties.find(string);
            jsonParser.nextToken();
            if (settableBeanProperty != null) {
                if (object != null) {
                    settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
                } else {
                    if (objectArray == null) {
                        n3 = this._beanProperties.size();
                        objectArray = new Object[n3 + n3];
                    }
                    objectArray[n2++] = settableBeanProperty;
                    objectArray[n2++] = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                }
            } else {
                n3 = PROP_NAME_MESSAGE.equals(string);
                if (n3 != 0 && bl2) {
                    object = this._valueInstantiator.createFromString(deserializationContext, jsonParser.getValueAsString());
                    if (objectArray != null) {
                        int n4 = n2;
                        for (int i2 = 0; i2 < n4; i2 += 2) {
                            settableBeanProperty = (SettableBeanProperty)objectArray[i2];
                            settableBeanProperty.set(object, objectArray[i2 + 1]);
                        }
                        objectArray = null;
                    }
                } else if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                    jsonParser.skipChildren();
                } else if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
                } else {
                    this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
                }
            }
            jsonParser.nextToken();
        }
        if (object == null) {
            object = bl2 ? this._valueInstantiator.createFromString(deserializationContext, null) : this._valueInstantiator.createUsingDefault(deserializationContext);
            if (objectArray != null) {
                int n5 = n2;
                for (int i3 = 0; i3 < n5; i3 += 2) {
                    SettableBeanProperty settableBeanProperty = (SettableBeanProperty)objectArray[i3];
                    settableBeanProperty.set(object, objectArray[i3 + 1]);
                }
            }
        }
        return object;
    }
}

