/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ext;

import java.io.IOException;
import java.nio.file.Path;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.type.WritableTypeId;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

public class NioPathSerializer
extends StdScalarSerializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathSerializer() {
        super(Path.class);
    }

    @Override
    public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(path.toUri().toString());
    }

    @Override
    public void serializeWithType(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)path, Path.class, JsonToken.VALUE_STRING));
        this.serialize(path, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }
}

