/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.introspect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.type.TypeBindings;
import zz.com.fasterxml.jackson.databind.util.Annotations;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class AnnotatedClassResolver {
    private static final Annotations NO_ANNOTATIONS = AnnotationCollector.emptyAnnotations();
    private final MapperConfig<?> _config;
    private final AnnotationIntrospector _intr;
    private final ClassIntrospector.MixInResolver _mixInResolver;
    private final TypeBindings _bindings;
    private final JavaType _type;
    private final Class<?> _class;
    private final Class<?> _primaryMixin;

    AnnotatedClassResolver(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        this._config = mapperConfig;
        this._type = javaType;
        this._class = javaType.getRawClass();
        this._mixInResolver = mixInResolver;
        this._bindings = javaType.getBindings();
        this._intr = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        this._primaryMixin = this._config.findMixInClassFor(this._class);
    }

    AnnotatedClassResolver(MapperConfig<?> mapperConfig, Class<?> clazz, ClassIntrospector.MixInResolver mixInResolver) {
        this._config = mapperConfig;
        this._type = null;
        this._class = clazz;
        this._mixInResolver = mixInResolver;
        this._bindings = TypeBindings.emptyBindings();
        if (mapperConfig == null) {
            this._intr = null;
            this._primaryMixin = null;
        } else {
            this._intr = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
            this._primaryMixin = this._config.findMixInClassFor(this._class);
        }
    }

    public static AnnotatedClass resolve(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        if (javaType.isArrayType() && AnnotatedClassResolver.skippableArray(mapperConfig, javaType.getRawClass())) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, javaType.getRawClass());
        }
        return new AnnotatedClassResolver(mapperConfig, javaType, mixInResolver).resolveFully();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, clazz, mapperConfig);
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        if (javaType.isArrayType() && AnnotatedClassResolver.skippableArray(mapperConfig, javaType.getRawClass())) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, javaType.getRawClass());
        }
        return new AnnotatedClassResolver(mapperConfig, javaType, mixInResolver).resolveWithoutSuperTypes();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, Class<?> clazz, ClassIntrospector.MixInResolver mixInResolver) {
        if (clazz.isArray() && AnnotatedClassResolver.skippableArray(mapperConfig, clazz)) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, clazz);
        }
        return new AnnotatedClassResolver(mapperConfig, clazz, mixInResolver).resolveWithoutSuperTypes();
    }

    private static boolean skippableArray(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return mapperConfig == null || mapperConfig.findMixInClassFor(clazz) == null;
    }

    static AnnotatedClass createPrimordial(Class<?> clazz) {
        return new AnnotatedClass(clazz);
    }

    static AnnotatedClass createArrayType(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return new AnnotatedClass(clazz);
    }

    AnnotatedClass resolveFully() {
        List<JavaType> list = ClassUtil.findSuperTypes(this._type, null, false);
        return new AnnotatedClass(this._type, this._class, list, this._primaryMixin, this.resolveClassAnnotations(list), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory());
    }

    AnnotatedClass resolveWithoutSuperTypes() {
        List<JavaType> list = Collections.emptyList();
        return new AnnotatedClass(null, this._class, list, this._primaryMixin, this.resolveClassAnnotations(list), this._bindings, this._intr, this._config, this._config.getTypeFactory());
    }

    private Annotations resolveClassAnnotations(List<JavaType> list) {
        if (this._intr == null) {
            return NO_ANNOTATIONS;
        }
        AnnotationCollector annotationCollector = AnnotationCollector.emptyCollector();
        if (this._primaryMixin != null) {
            annotationCollector = this._addClassMixIns(annotationCollector, this._class, this._primaryMixin);
        }
        annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(this._class));
        for (JavaType javaType : list) {
            if (this._mixInResolver != null) {
                Class<?> clazz = javaType.getRawClass();
                annotationCollector = this._addClassMixIns(annotationCollector, clazz, this._mixInResolver.findMixInClassFor(clazz));
            }
            annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(javaType.getRawClass()));
        }
        if (this._mixInResolver != null) {
            annotationCollector = this._addClassMixIns(annotationCollector, Object.class, this._mixInResolver.findMixInClassFor(Object.class));
        }
        return annotationCollector.asAnnotations();
    }

    private AnnotationCollector _addClassMixIns(AnnotationCollector annotationCollector, Class<?> clazz, Class<?> clazz2) {
        if (clazz2 != null) {
            annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(clazz2));
            for (Class<?> clazz3 : ClassUtil.findSuperClasses(clazz2, clazz, false)) {
                annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(clazz3));
            }
        }
        return annotationCollector;
    }

    private AnnotationCollector _addAnnotationsIfNotPresent(AnnotationCollector annotationCollector, Annotation[] annotationArray) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                if (annotationCollector.isPresent(annotation)) continue;
                annotationCollector = annotationCollector.addOrOverride(annotation);
                if (!this._intr.isAnnotationBundle(annotation)) continue;
                annotationCollector = this._addFromBundleIfNotPresent(annotationCollector, annotation);
            }
        }
        return annotationCollector;
    }

    private AnnotationCollector _addFromBundleIfNotPresent(AnnotationCollector annotationCollector, Annotation annotation) {
        for (Annotation annotation2 : ClassUtil.findClassAnnotations(annotation.annotationType())) {
            if (annotation2 instanceof Target || annotation2 instanceof Retention || annotationCollector.isPresent(annotation2)) continue;
            annotationCollector = annotationCollector.addOrOverride(annotation2);
            if (!this._intr.isAnnotationBundle(annotation2)) continue;
            annotationCollector = this._addFromBundleIfNotPresent(annotationCollector, annotation2);
        }
        return annotationCollector;
    }
}

