/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.introspect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import zz.com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.CollectorBase;
import zz.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class AnnotatedFieldCollector
extends CollectorBase {
    private final TypeFactory _typeFactory;
    private final ClassIntrospector.MixInResolver _mixInResolver;

    AnnotatedFieldCollector(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, ClassIntrospector.MixInResolver mixInResolver) {
        super(annotationIntrospector);
        this._typeFactory = typeFactory;
        this._mixInResolver = annotationIntrospector == null ? null : mixInResolver;
    }

    public static List<AnnotatedField> collectFields(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, JavaType javaType) {
        return new AnnotatedFieldCollector(annotationIntrospector, typeFactory, mixInResolver).collect(typeResolutionContext, javaType);
    }

    List<AnnotatedField> collect(TypeResolutionContext typeResolutionContext, JavaType javaType) {
        Map<String, FieldBuilder> map = this._findFields(typeResolutionContext, javaType, null);
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedField> arrayList = new ArrayList<AnnotatedField>(map.size());
        for (FieldBuilder fieldBuilder : map.values()) {
            arrayList.add(fieldBuilder.build());
        }
        return arrayList;
    }

    private Map<String, FieldBuilder> _findFields(TypeResolutionContext typeResolutionContext, JavaType javaType, Map<String, FieldBuilder> map) {
        JavaType javaType2 = javaType.getSuperClass();
        if (javaType2 == null) {
            return map;
        }
        Class<?> clazz = javaType.getRawClass();
        map = this._findFields(new TypeResolutionContext.Basic(this._typeFactory, javaType2.getBindings()), javaType2, map);
        Object object = ClassUtil.getDeclaredFields(clazz);
        int n2 = ((Field[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = object[i2];
            if (!this._isIncludableField(field)) continue;
            if (map == null) {
                map = new LinkedHashMap<String, FieldBuilder>();
            }
            FieldBuilder fieldBuilder = new FieldBuilder(typeResolutionContext, field);
            if (this._intr != null) {
                fieldBuilder.annotations = this.collectAnnotations(fieldBuilder.annotations, field.getDeclaredAnnotations());
            }
            map.put(field.getName(), fieldBuilder);
        }
        if (this._mixInResolver != null && (object = this._mixInResolver.findMixInClassFor(clazz)) != null) {
            this._addFieldMixIns((Class<?>)object, clazz, map);
        }
        return map;
    }

    private void _addFieldMixIns(Class<?> clazz, Class<?> clazz2, Map<String, FieldBuilder> map) {
        List<Class<?>> list = ClassUtil.findSuperClasses(clazz, clazz2, true);
        for (Class<?> clazz3 : list) {
            for (Field field : ClassUtil.getDeclaredFields(clazz3)) {
                String string;
                FieldBuilder fieldBuilder;
                if (!this._isIncludableField(field) || (fieldBuilder = map.get(string = field.getName())) == null) continue;
                fieldBuilder.annotations = this.collectAnnotations(fieldBuilder.annotations, field.getDeclaredAnnotations());
            }
        }
    }

    private boolean _isIncludableField(Field field) {
        if (field.isSynthetic()) {
            return false;
        }
        int n2 = field.getModifiers();
        return !Modifier.isStatic(n2);
    }

    private static final class FieldBuilder {
        public final TypeResolutionContext typeContext;
        public final Field field;
        public AnnotationCollector annotations;

        public FieldBuilder(TypeResolutionContext typeResolutionContext, Field field) {
            this.typeContext = typeResolutionContext;
            this.field = field;
            this.annotations = AnnotationCollector.emptyCollector();
        }

        public AnnotatedField build() {
            return new AnnotatedField(this.typeContext, this.field, this.annotations.asAnnotationMap());
        }
    }
}

