/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import zz.com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.CollectorBase;
import zz.com.fasterxml.jackson.databind.introspect.MemberKey;
import zz.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class AnnotatedMethodCollector
extends CollectorBase {
    private final ClassIntrospector.MixInResolver _mixInResolver;

    AnnotatedMethodCollector(AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver) {
        super(annotationIntrospector);
        this._mixInResolver = annotationIntrospector == null ? null : mixInResolver;
    }

    public static AnnotatedMethodMap collectMethods(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, JavaType javaType, List<JavaType> list, Class<?> clazz) {
        return new AnnotatedMethodCollector(annotationIntrospector, mixInResolver).collect(typeFactory, typeResolutionContext, javaType, list, clazz);
    }

    AnnotatedMethodMap collect(TypeFactory typeFactory, TypeResolutionContext typeResolutionContext, JavaType javaType, List<JavaType> list, Class<?> clazz) {
        LinkedHashMap<MemberKey, MethodBuilder> linkedHashMap = new LinkedHashMap<MemberKey, MethodBuilder>();
        this._addMemberMethods(typeResolutionContext, javaType.getRawClass(), linkedHashMap, clazz);
        for (JavaType object : list) {
            Class<?> clazz2 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(object.getRawClass());
            this._addMemberMethods(new TypeResolutionContext.Basic(typeFactory, object.getBindings()), object.getRawClass(), linkedHashMap, clazz2);
        }
        if (linkedHashMap.isEmpty()) {
            return new AnnotatedMethodMap();
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            AnnotatedMethod annotatedMethod = ((MethodBuilder)entry.getValue()).build();
            if (annotatedMethod == null) continue;
            linkedHashMap2.put(entry.getKey(), annotatedMethod);
        }
        return new AnnotatedMethodMap(linkedHashMap2);
    }

    private void _addMemberMethods(TypeResolutionContext typeResolutionContext, Class<?> clazz, Map<MemberKey, MethodBuilder> map, Class<?> clazz2) {
        if (clazz2 != null) {
            this._addMethodMixIns(typeResolutionContext, clazz, map, clazz2);
        }
        if (clazz == null) {
            return;
        }
        for (Method method : ClassUtil.getClassMethods(clazz)) {
            Object object;
            if (!this._isIncludableMemberMethod(method)) continue;
            MemberKey memberKey = new MemberKey(method);
            MethodBuilder methodBuilder = map.get(memberKey);
            if (methodBuilder == null) {
                object = this._intr == null ? AnnotationCollector.emptyCollector() : this.collectAnnotations(method.getDeclaredAnnotations());
                map.put(memberKey, new MethodBuilder(typeResolutionContext, method, (AnnotationCollector)object));
                continue;
            }
            if (this._intr != null) {
                methodBuilder.annotations = this.collectDefaultAnnotations(methodBuilder.annotations, method.getDeclaredAnnotations());
            }
            if ((object = methodBuilder.method) == null) {
                methodBuilder.method = method;
                continue;
            }
            if (!Modifier.isAbstract(((Method)object).getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            methodBuilder.method = method;
            methodBuilder.typeContext = typeResolutionContext;
        }
    }

    protected void _addMethodMixIns(TypeResolutionContext typeResolutionContext, Class<?> clazz, Map<MemberKey, MethodBuilder> map, Class<?> clazz2) {
        if (this._intr == null) {
            return;
        }
        for (Class<?> clazz3 : ClassUtil.findRawSuperTypes(clazz2, clazz, true)) {
            for (Method method : ClassUtil.getDeclaredMethods(clazz3)) {
                if (!this._isIncludableMemberMethod(method)) continue;
                MemberKey memberKey = new MemberKey(method);
                MethodBuilder methodBuilder = map.get(memberKey);
                Annotation[] annotationArray = method.getDeclaredAnnotations();
                if (methodBuilder == null) {
                    map.put(memberKey, new MethodBuilder(typeResolutionContext, null, this.collectAnnotations(annotationArray)));
                    continue;
                }
                methodBuilder.annotations = this.collectDefaultAnnotations(methodBuilder.annotations, annotationArray);
            }
        }
    }

    private boolean _isIncludableMemberMethod(Method method) {
        if (Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || method.isBridge()) {
            return false;
        }
        int n2 = method.getParameterTypes().length;
        return n2 <= 2;
    }

    private static final class MethodBuilder {
        public TypeResolutionContext typeContext;
        public Method method;
        public AnnotationCollector annotations;

        public MethodBuilder(TypeResolutionContext typeResolutionContext, Method method, AnnotationCollector annotationCollector) {
            this.typeContext = typeResolutionContext;
            this.method = method;
            this.annotations = annotationCollector;
        }

        public AnnotatedMethod build() {
            if (this.method == null) {
                return null;
            }
            return new AnnotatedMethod(this.typeContext, this.method, this.annotations.asAnnotationMap(), null);
        }
    }
}

