/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.DeserializationConfig;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import zz.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import zz.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import zz.com.fasterxml.jackson.databind.type.SimpleType;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.LRUMap;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final BasicBeanDescription STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), AnnotatedClassResolver.createPrimordial(String.class));
    protected static final BasicBeanDescription BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), AnnotatedClassResolver.createPrimordial(Boolean.TYPE));
    protected static final BasicBeanDescription INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), AnnotatedClassResolver.createPrimordial(Integer.TYPE));
    protected static final BasicBeanDescription LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), AnnotatedClassResolver.createPrimordial(Long.TYPE));
    protected final LRUMap<JavaType, BasicBeanDescription> _cachedFCA = new LRUMap(16, 64);

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = this._findStdJdkCollectionDesc(serializationConfig, javaType);
            if (basicBeanDescription == null) {
                basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, mixInResolver, true, "set"));
            }
            this._cachedFCA.putIfAbsent(javaType, basicBeanDescription);
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType);
            if (basicBeanDescription == null) {
                basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false, "set"));
            }
            this._cachedFCA.putIfAbsent(javaType, basicBeanDescription);
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, false));
        this._cachedFCA.putIfAbsent(javaType, basicBeanDescription);
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false, "set"));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._cachedFCA.get(javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver));
            this._cachedFCA.put(javaType, basicBeanDescription);
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedWithoutSuperTypes(mapperConfig, javaType, mixInResolver));
        }
        return basicBeanDescription;
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl2, String string) {
        return this.constructPropertyCollector(mapperConfig, this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver), javaType, bl2, string);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl2) {
        AnnotatedClass annotatedClass = this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver);
        AnnotationIntrospector annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        JsonPOJOBuilder.Value value = annotationIntrospector == null ? null : annotationIntrospector.findPOJOBuilderConfig(annotatedClass);
        String string = value == null ? "with" : value.withPrefix;
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl2, string);
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl2, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl2, javaType, annotatedClass, string);
    }

    protected BasicBeanDescription _findStdTypeDesc(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
            if (clazz == Integer.TYPE) {
                return INT_DESC;
            }
            if (clazz == Long.TYPE) {
                return LONG_DESC;
            }
        } else if (clazz == String.class) {
            return STRING_DESC;
        }
        return null;
    }

    protected boolean _isStdJDKCollection(JavaType javaType) {
        if (!javaType.isContainerType() || javaType.isArrayType()) {
            return false;
        }
        Class<?> clazz = javaType.getRawClass();
        String string = ClassUtil.getPackageName(clazz);
        return !(string == null || !string.startsWith("java.lang") && !string.startsWith("java.util") || !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz));
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (this._isStdJDKCollection(javaType)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mapperConfig));
        }
        return null;
    }

    protected AnnotatedClass _resolveAnnotatedClass(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolve(mapperConfig, javaType, mixInResolver);
    }

    protected AnnotatedClass _resolveAnnotatedWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, javaType, mixInResolver);
    }
}

