/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.PropertyMetadata;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;

public abstract class ConcreteBeanPropertyBase
implements Serializable,
BeanProperty {
    private static final long serialVersionUID = 1L;
    protected final PropertyMetadata _metadata;
    protected transient JsonFormat.Value _propertyFormat;
    protected transient List<PropertyName> _aliases;

    protected ConcreteBeanPropertyBase(PropertyMetadata propertyMetadata) {
        this._metadata = propertyMetadata == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : propertyMetadata;
    }

    protected ConcreteBeanPropertyBase(ConcreteBeanPropertyBase concreteBeanPropertyBase) {
        this._metadata = concreteBeanPropertyBase._metadata;
        this._propertyFormat = concreteBeanPropertyBase._propertyFormat;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    @Deprecated
    public final JsonFormat.Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
        AnnotatedMember annotatedMember;
        JsonFormat.Value value = null;
        if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
            value = annotationIntrospector.findFormat(annotatedMember);
        }
        if (value == null) {
            value = EMPTY_FORMAT;
        }
        return value;
    }

    @Override
    public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
        JsonFormat.Value value = this._propertyFormat;
        if (value == null) {
            AnnotatedMember annotatedMember;
            JsonFormat.Value value2 = mapperConfig.getDefaultPropertyFormat(clazz);
            JsonFormat.Value value3 = null;
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
                value3 = annotationIntrospector.findFormat(annotatedMember);
            }
            value = value2 == null ? (value3 == null ? EMPTY_FORMAT : value3) : (value3 == null ? value2 : value2.withOverrides(value3));
            this._propertyFormat = value;
        }
        return value;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = this.getMember();
        if (annotatedMember == null) {
            JsonInclude.Value value = mapperConfig.getDefaultPropertyInclusion(clazz);
            return value;
        }
        JsonInclude.Value value = mapperConfig.getDefaultInclusion(clazz, annotatedMember.getRawType());
        if (annotationIntrospector == null) {
            return value;
        }
        JsonInclude.Value value2 = annotationIntrospector.findPropertyInclusion(annotatedMember);
        if (value == null) {
            return value2;
        }
        return value.withOverrides(value2);
    }

    @Override
    public List<PropertyName> findAliases(MapperConfig<?> mapperConfig) {
        List<PropertyName> list = this._aliases;
        if (list == null) {
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector != null) {
                list = annotationIntrospector.findPropertyAliases(this.getMember());
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            this._aliases = list;
        }
        return list;
    }
}

