/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.introspect;

import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import zz.com.fasterxml.jackson.annotation.JacksonInject;
import zz.com.fasterxml.jackson.annotation.JsonCreator;
import zz.com.fasterxml.jackson.annotation.JsonProperty;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import zz.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.introspect.Annotated;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import zz.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import zz.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import zz.com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import zz.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import zz.com.fasterxml.jackson.databind.util.BeanUtil;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final boolean _forSerialization;
    protected final boolean _stdBeanNaming;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final boolean _useAnnotations;
    protected final String _mutatorPrefix;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected LinkedList<POJOPropertyBuilder> _creatorProperties;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMember> _jsonValueAccessors;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl2, JavaType javaType, AnnotatedClass annotatedClass, String string) {
        this._config = mapperConfig;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._forSerialization = bl2;
        this._type = javaType;
        this._classDef = annotatedClass;
        String string2 = this._mutatorPrefix = string == null ? "set" : string;
        if (mapperConfig.isAnnotationProcessingEnabled()) {
            this._useAnnotations = true;
            this._annotationIntrospector = this._config.getAnnotationIntrospector();
        } else {
            this._useAnnotations = false;
            this._annotationIntrospector = AnnotationIntrospector.nopInstance();
        }
        this._visibilityChecker = this._config.getDefaultVisibilityChecker(javaType.getRawClass(), annotatedClass);
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = this.getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    @Deprecated
    public AnnotatedMethod getJsonValueMethod() {
        AnnotatedMember annotatedMember = this.getJsonValueAccessor();
        if (annotatedMember instanceof AnnotatedMethod) {
            return (AnnotatedMethod)annotatedMember;
        }
        return null;
    }

    public AnnotatedMember getJsonValueAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonValueAccessors != null) {
            if (this._jsonValueAccessors.size() > 1) {
                this.reportProblem("Multiple 'as-value' properties defined (%s vs %s)", this._jsonValueAccessors.get(0), this._jsonValueAccessors.get(1));
            }
            return this._jsonValueAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getAnyGetter() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getters' defined (%s vs %s)", this._anyGetters.get(0), this._anyGetters.get(1));
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetterField != null) {
            if (this._anySetterField.size() > 1) {
                this.reportProblem("Multiple 'any-setter' fields defined (%s vs %s)", this._anySetterField.get(0), this._anySetterField.get(1));
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setter' methods defined (%s vs %s)", this._anySetters.get(0), this._anySetters.get(1));
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    protected void collectAll() {
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>();
        this._addFields(linkedHashMap);
        this._addMethods(linkedHashMap);
        if (!this._classDef.isNonStaticInnerClass()) {
            this._addCreators(linkedHashMap);
        }
        this._addInjectables(linkedHashMap);
        this._removeUnwantedProperties(linkedHashMap);
        this._removeUnwantedAccessor(linkedHashMap);
        this._renameProperties(linkedHashMap);
        for (POJOPropertyBuilder object : linkedHashMap.values()) {
            object.mergeAnnotations(this._forSerialization);
        }
        PropertyNamingStrategy propertyNamingStrategy = this._findNamingStrategy();
        if (propertyNamingStrategy != null) {
            this._renameUsing(linkedHashMap, propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap);
        }
        this._sortProperties(linkedHashMap);
        this._properties = linkedHashMap;
        this._collected = true;
    }

    protected void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl2 = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl3 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl4;
            PropertyName propertyName;
            boolean bl5;
            boolean bl6;
            String string = annotationIntrospector.findImplicitPropertyName(annotatedField);
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedField))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedField);
                continue;
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAnySetter(annotatedField))) {
                if (this._anySetterField == null) {
                    this._anySetterField = new LinkedList();
                }
                this._anySetterField.add(annotatedField);
                continue;
            }
            if (string == null) {
                string = annotatedField.getName();
            }
            if ((bl6 = (bl5 = (propertyName = this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField)) != null)) && propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl6 = false;
            }
            boolean bl7 = bl4 = propertyName != null;
            if (!bl4) {
                bl4 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl8 = annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (annotatedField.isTransient() && !bl5) {
                bl4 = false;
                if (bl3) {
                    bl8 = true;
                }
            }
            if (bl2 && propertyName == null && !bl8 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            this._property(map, string).addField(annotatedField, propertyName, bl6, bl4, bl8);
        }
    }

    protected void _addCreators(Map<String, POJOPropertyBuilder> map) {
        int n2;
        int n3;
        if (!this._useAnnotations) {
            return;
        }
        for (AnnotatedConstructor annotatedWithParams : this._classDef.getConstructors()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n3 = annotatedWithParams.getParameterCount();
            for (n2 = 0; n2 < n3; ++n2) {
                this._addCreatorParam(map, annotatedWithParams.getParameter(n2));
            }
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.getFactoryMethods()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n3 = annotatedMethod.getParameterCount();
            for (n2 = 0; n2 < n3; ++n2) {
                this._addCreatorParam(map, annotatedMethod.getParameter(n2));
            }
        }
    }

    protected void _addCreatorParam(Map<String, POJOPropertyBuilder> map, AnnotatedParameter annotatedParameter) {
        Object object;
        PropertyName propertyName;
        boolean bl2;
        String string = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter);
        if (string == null) {
            string = "";
        }
        boolean bl3 = bl2 = (propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedParameter)) != null && !propertyName.isEmpty();
        if (!bl2) {
            if (string.isEmpty()) {
                return;
            }
            object = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedParameter.getOwner());
            if (object == null || object == JsonCreator.Mode.DISABLED) {
                return;
            }
            propertyName = PropertyName.construct(string);
        }
        object = bl2 && string.isEmpty() ? this._property(map, propertyName) : this._property(map, string);
        object.addCtor(annotatedParameter, propertyName, bl2, true, false);
        this._creatorProperties.add((POJOPropertyBuilder)object);
    }

    protected void _addMethods(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 0) {
                this._addGetterMethod(map, annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n2 == 1) {
                this._addSetterMethod(map, annotatedMethod, annotationIntrospector);
                continue;
            }
            if (n2 != 2 || annotationIntrospector == null || !Boolean.TRUE.equals(annotationIntrospector.hasAnySetter(annotatedMethod))) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        String string;
        boolean bl3;
        if (!annotatedMethod.hasReturnType()) {
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedMethod))) {
            if (this._anyGetters == null) {
                this._anyGetters = new LinkedList();
            }
            this._anyGetters.add(annotatedMethod);
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedMethod))) {
            if (this._jsonValueAccessors == null) {
                this._jsonValueAccessors = new LinkedList();
            }
            this._jsonValueAccessors.add(annotatedMethod);
            return;
        }
        PropertyName propertyName = annotationIntrospector.findNameForSerialization(annotatedMethod);
        boolean bl4 = bl3 = propertyName != null;
        if (!bl3) {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForRegularGetter(annotatedMethod, annotatedMethod.getName(), this._stdBeanNaming);
            }
            if (string == null) {
                string = BeanUtil.okNameForIsGetter(annotatedMethod, annotatedMethod.getName(), this._stdBeanNaming);
                if (string == null) {
                    return;
                }
                bl2 = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl2 = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForGetter(annotatedMethod, this._stdBeanNaming);
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl3 = false;
            }
            bl2 = true;
        }
        boolean bl5 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addGetter(annotatedMethod, propertyName, bl3, bl2, bl5);
    }

    protected void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        String string;
        boolean bl3;
        PropertyName propertyName = annotationIntrospector == null ? null : annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl4 = bl3 = propertyName != null;
        if (!bl3) {
            String string2 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForMutator(annotatedMethod, this._mutatorPrefix, this._stdBeanNaming);
            }
            if (string == null) {
                return;
            }
            bl2 = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            String string3 = string = annotationIntrospector == null ? null : annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = BeanUtil.okNameForMutator(annotatedMethod, this._mutatorPrefix, this._stdBeanNaming);
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl3 = false;
            }
            bl2 = true;
        }
        boolean bl5 = annotationIntrospector == null ? false : annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addSetter(annotatedMethod, propertyName, bl3, bl2, bl5);
    }

    protected void _addInjectables(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        for (AnnotatedField annotatedMember : this._classDef.fields()) {
            this._doAddInjectable(annotationIntrospector.findInjectableValue(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (annotatedMethod.getParameterCount() != 1) continue;
            this._doAddInjectable(annotationIntrospector.findInjectableValue(annotatedMethod), annotatedMethod);
        }
    }

    protected void _doAddInjectable(JacksonInject.Value value, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (value == null) {
            return;
        }
        Object object = value.getId();
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null && annotatedMember2.getClass() == annotatedMember.getClass()) {
            String string = object.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + String.valueOf(object) + "' (of type " + string + ")");
        }
    }

    private PropertyName _propNameFromSimple(String string) {
        return PropertyName.construct(string, null);
    }

    protected void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> map) {
        Iterator<POJOPropertyBuilder> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = iterator.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                iterator.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (!pOJOPropertyBuilder.isExplicitlyIncluded()) {
                iterator.remove();
                this._collectIgnorals(pOJOPropertyBuilder.getName());
                continue;
            }
            pOJOPropertyBuilder.removeIgnored();
            if (pOJOPropertyBuilder.couldDeserialize()) continue;
            this._collectIgnorals(pOJOPropertyBuilder.getName());
        }
    }

    protected void _removeUnwantedAccessor(Map<String, POJOPropertyBuilder> map) {
        boolean bl2 = this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
            JsonProperty.Access access = pOJOPropertyBuilder.removeNonVisible(bl2);
            if (access != JsonProperty.Access.READ_ONLY) continue;
            this._collectIgnorals(pOJOPropertyBuilder.getName());
        }
    }

    private void _collectIgnorals(String string) {
        if (!this._forSerialization) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    protected void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.findExplicitNames();
            if (object2.isEmpty()) continue;
            iterator.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            if (object2.size() == 1) {
                object = (PropertyName)object2.iterator().next();
                linkedList.add(pOJOPropertyBuilder.withName((PropertyName)object));
                continue;
            }
            linkedList.addAll(pOJOPropertyBuilder.explode((Collection<PropertyName>)object2));
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                } else {
                    ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
                }
                this._updateCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
            }
        }
    }

    protected void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            String string;
            PropertyName propertyName = pOJOPropertyBuilder.getFullName();
            String string2 = null;
            if (!pOJOPropertyBuilder.isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                if (this._forSerialization) {
                    if (pOJOPropertyBuilder.hasGetter()) {
                        string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                    } else if (pOJOPropertyBuilder.hasField()) {
                        string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                    }
                } else if (pOJOPropertyBuilder.hasSetter()) {
                    string2 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasConstructorParameter()) {
                    string2 = propertyNamingStrategy.nameForConstructorParameter(this._config, pOJOPropertyBuilder.getConstructorParameter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasField()) {
                    string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasGetter()) {
                    string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                }
            }
            if (string2 != null && !propertyName.hasSimpleName(string2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName(string2);
                string = string2;
            } else {
                string = propertyName.getSimpleName();
            }
            POJOPropertyBuilder pOJOPropertyBuilder2 = map.get(string);
            if (pOJOPropertyBuilder2 == null) {
                map.put(string, pOJOPropertyBuilder);
            } else {
                pOJOPropertyBuilder2.addAll(pOJOPropertyBuilder);
            }
            this._updateCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
        }
    }

    protected void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(pOJOPropertyBuilder.getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        Boolean bl2 = annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
        boolean bl3 = bl2 == null ? this._config.shouldSortPropertiesAlphabetically() : bl2.booleanValue();
        String[] stringArray = annotationIntrospector.findSerializationPropertyOrder(this._classDef);
        if (!bl3 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n2 = map.size();
        AbstractMap abstractMap = bl3 ? new TreeMap() : new LinkedHashMap(n2 + n2);
        for (POJOPropertyBuilder object : map.values()) {
            abstractMap.put(object.getName(), object);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(n2 + n2);
        if (stringArray != null) {
            for (String string : stringArray) {
                void var12_21;
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)abstractMap.get(string);
                if (pOJOPropertyBuilder == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
                        if (!string.equals(pOJOPropertyBuilder2.getInternalName())) continue;
                        pOJOPropertyBuilder = pOJOPropertyBuilder2;
                        String string2 = pOJOPropertyBuilder2.getName();
                        break;
                    }
                }
                if (pOJOPropertyBuilder == null) continue;
                linkedHashMap.put(var12_21, pOJOPropertyBuilder);
            }
        }
        if (this._creatorProperties != null) {
            void var9_14;
            if (bl3) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    treeMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                LinkedList<POJOPropertyBuilder> linkedList = this._creatorProperties;
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : var9_14) {
                String string = pOJOPropertyBuilder.getName();
                if (!abstractMap.containsKey(string)) continue;
                linkedHashMap.put(string, pOJOPropertyBuilder);
            }
        }
        linkedHashMap.putAll(abstractMap);
        map.clear();
        map.putAll(linkedHashMap);
    }

    protected void reportProblem(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, PropertyName propertyName) {
        String string = propertyName.getSimpleName();
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, PropertyName.construct(string));
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        PropertyNamingStrategy propertyNamingStrategy;
        Object object = this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned PropertyNamingStrategy definition of type " + object.getClass().getName() + "; expected type PropertyNamingStrategy or Class<PropertyNamingStrategy> instead");
        }
        Class clazz = (Class)object;
        if (clazz == PropertyNamingStrategy.class) {
            return null;
        }
        if (!PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<PropertyNamingStrategy>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        if (handlerInstantiator != null && (propertyNamingStrategy = handlerInstantiator.namingStrategyInstance(this._config, this._classDef, clazz)) != null) {
            return propertyNamingStrategy;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
    }

    protected void _updateCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!list.get(i2).getInternalName().equals(pOJOPropertyBuilder.getInternalName())) continue;
                list.set(i2, pOJOPropertyBuilder);
                break;
            }
        }
    }
}

