/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import java.io.Serializable;
import zz.com.fasterxml.jackson.annotation.JsonTypeInfo;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.util.JsonParserSequence;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import zz.com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import zz.com.fasterxml.jackson.databind.util.TokenBuffer;

public class AsArrayTypeDeserializer
extends TypeDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    public AsArrayTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl2, JavaType javaType2) {
        super(javaType, typeIdResolver, string, bl2, javaType2);
    }

    public AsArrayTypeDeserializer(AsArrayTypeDeserializer asArrayTypeDeserializer, BeanProperty beanProperty) {
        super(asArrayTypeDeserializer, beanProperty);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        return beanProperty == this._property ? this : new AsArrayTypeDeserializer(this, beanProperty);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    protected Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        Object object2;
        if (jsonParser.canReadTypeId() && (object2 = jsonParser.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jsonParser, deserializationContext, object2);
        }
        boolean bl2 = jsonParser.isExpectedStartArrayToken();
        String string = this._locateTypeId(jsonParser, deserializationContext);
        JsonDeserializer<Object> jsonDeserializer = this._findDeserializer(deserializationContext, string);
        if (this._typeIdVisible && !this._usesExternalId() && jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            object = new TokenBuffer(null, false);
            ((TokenBuffer)object).writeStartObject();
            ((TokenBuffer)object).writeFieldName(this._typePropertyName);
            ((TokenBuffer)object).writeString(string);
            jsonParser.clearCurrentToken();
            jsonParser = JsonParserSequence.createFlattened(false, ((TokenBuffer)object).asParser(jsonParser), jsonParser);
            jsonParser.nextToken();
        }
        object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        if (bl2 && jsonParser.nextToken() != JsonToken.END_ARRAY) {
            deserializationContext.reportWrongTokenException(this.baseType(), JsonToken.END_ARRAY, "expected closing END_ARRAY after type information and deserialized value", new Object[0]);
        }
        return object;
    }

    protected String _locateTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            if (this._defaultImpl != null) {
                return this._idResolver.idFromBaseType();
            }
            deserializationContext.reportWrongTokenException(this.baseType(), JsonToken.START_ARRAY, "need JSON Array to contain As.WRAPPER_ARRAY type information for class " + this.baseTypeName(), new Object[0]);
            return null;
        }
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText();
            jsonParser.nextToken();
            return string;
        }
        if (this._defaultImpl != null) {
            return this._idResolver.idFromBaseType();
        }
        deserializationContext.reportWrongTokenException(this.baseType(), JsonToken.VALUE_STRING, "need JSON String that contains type id (for subtype of %s)", this.baseTypeName());
        return null;
    }

    protected boolean _usesExternalId() {
        return false;
    }
}

