/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import zz.com.fasterxml.jackson.annotation.JsonTypeInfo;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.util.JsonParserSequence;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.DeserializationFeature;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import zz.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import zz.com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import zz.com.fasterxml.jackson.databind.util.TokenBuffer;

public class AsPropertyTypeDeserializer
extends AsArrayTypeDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JsonTypeInfo.As _inclusion;

    public AsPropertyTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl2, JavaType javaType2) {
        this(javaType, typeIdResolver, string, bl2, javaType2, JsonTypeInfo.As.PROPERTY);
    }

    public AsPropertyTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl2, JavaType javaType2, JsonTypeInfo.As as2) {
        super(javaType, typeIdResolver, string, bl2, javaType2);
        this._inclusion = as2;
    }

    public AsPropertyTypeDeserializer(AsPropertyTypeDeserializer asPropertyTypeDeserializer, BeanProperty beanProperty) {
        super(asPropertyTypeDeserializer, beanProperty);
        this._inclusion = asPropertyTypeDeserializer._inclusion;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        return beanProperty == this._property ? this : new AsPropertyTypeDeserializer(this, beanProperty);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return this._inclusion;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (jsonParser.canReadTypeId() && (object = jsonParser.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jsonParser, deserializationContext, object);
        }
        object = jsonParser.getCurrentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextToken();
        } else if (object != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null);
        }
        TokenBuffer tokenBuffer = null;
        while (object == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            if (string.equals(this._typePropertyName)) {
                return this._deserializeTypedForId(jsonParser, deserializationContext, tokenBuffer);
            }
            if (tokenBuffer == null) {
                tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
            }
            tokenBuffer.writeFieldName(string);
            tokenBuffer.copyCurrentStructure(jsonParser);
            object = jsonParser.nextToken();
        }
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, tokenBuffer);
    }

    protected Object _deserializeTypedForId(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer) throws IOException {
        String string = jsonParser.getText();
        JsonDeserializer<Object> jsonDeserializer = this._findDeserializer(deserializationContext, string);
        if (this._typeIdVisible) {
            if (tokenBuffer == null) {
                tokenBuffer = new TokenBuffer(jsonParser, deserializationContext);
            }
            tokenBuffer.writeFieldName(jsonParser.getCurrentName());
            tokenBuffer.writeString(string);
        }
        if (tokenBuffer != null) {
            jsonParser.clearCurrentToken();
            jsonParser = JsonParserSequence.createFlattened(false, tokenBuffer.asParser(jsonParser), jsonParser);
        }
        jsonParser.nextToken();
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    protected Object _deserializeTypedUsingDefaultImpl(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer) throws IOException {
        JsonDeserializer<Object> jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
        if (jsonDeserializer == null) {
            JavaType javaType;
            String string;
            Object object = TypeDeserializer.deserializeIfNatural(jsonParser, deserializationContext, this._baseType);
            if (object != null) {
                return object;
            }
            if (jsonParser.isExpectedStartArrayToken()) {
                return super.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            if (jsonParser.hasToken(JsonToken.VALUE_STRING) && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (string = jsonParser.getText().trim()).isEmpty()) {
                return null;
            }
            string = String.format("missing type id property '%s'", this._typePropertyName);
            if (this._property != null) {
                string = String.format("%s (for POJO property '%s')", string, this._property.getName());
            }
            if ((javaType = this._handleMissingTypeId(deserializationContext, string)) == null) {
                return null;
            }
            jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, this._property);
        }
        if (tokenBuffer != null) {
            tokenBuffer.writeEndObject();
            jsonParser = tokenBuffer.asParser(jsonParser);
            jsonParser.nextToken();
        }
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
            return super.deserializeTypedFromArray(jsonParser, deserializationContext);
        }
        return this.deserializeTypedFromObject(jsonParser, deserializationContext);
    }
}

