/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import zz.com.fasterxml.jackson.annotation.JsonTypeInfo;
import zz.com.fasterxml.jackson.databind.DatabindContext;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    private static final String JAVA_UTIL_PKG = "java.util.";

    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        super(javaType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> clazz, String string) {
    }

    @Override
    public String idFromValue(Object object) {
        return this._idFrom(object, object.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
        return this._typeFromId(string, databindContext);
    }

    protected JavaType _typeFromId(String string, DatabindContext databindContext) throws IOException {
        JavaType javaType = databindContext.resolveSubType(this._baseType, string);
        if (javaType == null && databindContext instanceof DeserializationContext) {
            return ((DeserializationContext)databindContext).handleUnknownTypeId(this._baseType, string, this, "no such class found");
        }
        return javaType;
    }

    protected String _idFrom(Object object, Class<?> clazz, TypeFactory typeFactory) {
        Class<?> clazz2;
        Class<?> clazz3;
        String string;
        if (Enum.class.isAssignableFrom(clazz) && !clazz.isEnum()) {
            clazz = clazz.getSuperclass();
        }
        if ((string = clazz.getName()).startsWith(JAVA_UTIL_PKG)) {
            if (object instanceof EnumSet) {
                Class<? extends Enum<?>> clazz4 = ClassUtil.findEnumType((EnumSet)object);
                string = typeFactory.constructCollectionType(EnumSet.class, clazz4).toCanonical();
            } else if (object instanceof EnumMap) {
                Class<? extends Enum<?>> clazz5 = ClassUtil.findEnumType((EnumMap)object);
                Class<Object> clazz6 = Object.class;
                string = typeFactory.constructMapType(EnumMap.class, clazz5, clazz6).toCanonical();
            }
        } else if (string.indexOf(36) >= 0 && (clazz3 = ClassUtil.getOuterClass(clazz)) != null && ClassUtil.getOuterClass(clazz2 = this._baseType.getRawClass()) == null) {
            clazz = this._baseType.getRawClass();
            string = clazz.getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

