/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonPointer;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.type.WritableTypeId;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.node.BaseJsonNode;
import zz.com.fasterxml.jackson.databind.node.ContainerNode;
import zz.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import zz.com.fasterxml.jackson.databind.node.JsonNodeType;
import zz.com.fasterxml.jackson.databind.node.MissingNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.databind.util.RawValue;

public class ArrayNode
extends ContainerNode<ArrayNode> {
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, int n2) {
        super(jsonNodeFactory);
        this._children = new ArrayList<JsonNode>(n2);
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, List<JsonNode> list) {
        super(jsonNodeFactory);
        this._children = list;
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode arrayNode = new ArrayNode(this._nodeFactory);
        for (JsonNode jsonNode : this._children) {
            arrayNode._children.add((JsonNode)jsonNode.deepCopy());
        }
        return arrayNode;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public JsonNode path(String string) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        int n2 = this._children.size();
        if (arrayNode.size() != n2) {
            return false;
        }
        List<JsonNode> list = this._children;
        List<JsonNode> list2 = arrayNode._children;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2).equals(comparator, list2.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<JsonNode> list = this._children;
        int n2 = list.size();
        jsonGenerator.writeStartArray(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonNode jsonNode = list.get(i2);
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode jsonNode : this._children) {
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public JsonNode findValue(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findValue(string);
            if (jsonNode2 == null) continue;
            return jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findParent(string);
            if (jsonNode2 == null) continue;
            return (ObjectNode)jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findParents(string, list);
        }
        return list;
    }

    public JsonNode set(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        if (n2 < 0 || n2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
        }
        return this._children.set(n2, jsonNode);
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._add(jsonNode);
        return this;
    }

    public ArrayNode addAll(ArrayNode arrayNode) {
        this._children.addAll(arrayNode._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> collection) {
        this._children.addAll(collection);
        return this;
    }

    public ArrayNode insert(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._insert(n2, jsonNode);
        return this;
    }

    public JsonNode remove(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.remove(n2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode arrayNode = this.arrayNode();
        this._add(arrayNode);
        return arrayNode;
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = this.objectNode();
        this._add(objectNode);
        return objectNode;
    }

    public ArrayNode addPOJO(Object object) {
        if (object == null) {
            this.addNull();
        } else {
            this._add(this.pojoNode(object));
        }
        return this;
    }

    public ArrayNode addRawValue(RawValue rawValue) {
        if (rawValue == null) {
            this.addNull();
        } else {
            this._add(this.rawValueNode(rawValue));
        }
        return this;
    }

    public ArrayNode addNull() {
        this._add(this.nullNode());
        return this;
    }

    public ArrayNode add(int n2) {
        this._add(this.numberNode(n2));
        return this;
    }

    public ArrayNode add(Integer n2) {
        if (n2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((int)n2));
    }

    public ArrayNode add(long l2) {
        return this._add(this.numberNode(l2));
    }

    public ArrayNode add(Long l2) {
        if (l2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((long)l2));
    }

    public ArrayNode add(float f2) {
        return this._add(this.numberNode(f2));
    }

    public ArrayNode add(Float f2) {
        if (f2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(f2.floatValue()));
    }

    public ArrayNode add(double d2) {
        return this._add(this.numberNode(d2));
    }

    public ArrayNode add(Double d2) {
        if (d2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((double)d2));
    }

    public ArrayNode add(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(bigDecimal));
    }

    public ArrayNode add(BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(bigInteger));
    }

    public ArrayNode add(String string) {
        if (string == null) {
            return this.addNull();
        }
        return this._add(this.textNode(string));
    }

    public ArrayNode add(boolean bl2) {
        return this._add(this.booleanNode(bl2));
    }

    public ArrayNode add(Boolean bl2) {
        if (bl2 == null) {
            return this.addNull();
        }
        return this._add(this.booleanNode(bl2));
    }

    public ArrayNode add(byte[] byArray) {
        if (byArray == null) {
            return this.addNull();
        }
        return this._add(this.binaryNode(byArray));
    }

    public ArrayNode insertArray(int n2) {
        ArrayNode arrayNode = this.arrayNode();
        this._insert(n2, arrayNode);
        return arrayNode;
    }

    public ObjectNode insertObject(int n2) {
        ObjectNode objectNode = this.objectNode();
        this._insert(n2, objectNode);
        return objectNode;
    }

    public ArrayNode insertPOJO(int n2, Object object) {
        if (object == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.pojoNode(object));
    }

    public ArrayNode insertNull(int n2) {
        this._insert(n2, this.nullNode());
        return this;
    }

    public ArrayNode insert(int n2, int n3) {
        this._insert(n2, this.numberNode(n3));
        return this;
    }

    public ArrayNode insert(int n2, Integer n3) {
        if (n3 == null) {
            this.insertNull(n2);
        } else {
            this._insert(n2, this.numberNode((int)n3));
        }
        return this;
    }

    public ArrayNode insert(int n2, long l2) {
        return this._insert(n2, this.numberNode(l2));
    }

    public ArrayNode insert(int n2, Long l2) {
        if (l2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode((long)l2));
    }

    public ArrayNode insert(int n2, float f2) {
        return this._insert(n2, this.numberNode(f2));
    }

    public ArrayNode insert(int n2, Float f2) {
        if (f2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(f2.floatValue()));
    }

    public ArrayNode insert(int n2, double d2) {
        return this._insert(n2, this.numberNode(d2));
    }

    public ArrayNode insert(int n2, Double d2) {
        if (d2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode((double)d2));
    }

    public ArrayNode insert(int n2, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(bigDecimal));
    }

    public ArrayNode insert(int n2, BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.numberNode(bigInteger));
    }

    public ArrayNode insert(int n2, String string) {
        if (string == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.textNode(string));
    }

    public ArrayNode insert(int n2, boolean bl2) {
        return this._insert(n2, this.booleanNode(bl2));
    }

    public ArrayNode insert(int n2, Boolean bl2) {
        if (bl2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.booleanNode(bl2));
    }

    public ArrayNode insert(int n2, byte[] byArray) {
        if (byArray == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)object)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode arrayNode) {
        return this._children.equals(arrayNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(16 + (this.size() << 4));
        stringBuilder.append('[');
        int n2 = this._children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this._children.get(i2).toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected ArrayNode _add(JsonNode jsonNode) {
        this._children.add(jsonNode);
        return this;
    }

    protected ArrayNode _insert(int n2, JsonNode jsonNode) {
        if (n2 < 0) {
            this._children.add(0, jsonNode);
        } else if (n2 >= this._children.size()) {
            this._children.add(jsonNode);
        } else {
            this._children.add(n2, jsonNode);
        }
        return this;
    }
}

