/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.BigIntegerNode;
import zz.com.fasterxml.jackson.databind.node.BinaryNode;
import zz.com.fasterxml.jackson.databind.node.BooleanNode;
import zz.com.fasterxml.jackson.databind.node.DecimalNode;
import zz.com.fasterxml.jackson.databind.node.DoubleNode;
import zz.com.fasterxml.jackson.databind.node.FloatNode;
import zz.com.fasterxml.jackson.databind.node.IntNode;
import zz.com.fasterxml.jackson.databind.node.JsonNodeCreator;
import zz.com.fasterxml.jackson.databind.node.LongNode;
import zz.com.fasterxml.jackson.databind.node.NullNode;
import zz.com.fasterxml.jackson.databind.node.NumericNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.databind.node.POJONode;
import zz.com.fasterxml.jackson.databind.node.ShortNode;
import zz.com.fasterxml.jackson.databind.node.TextNode;
import zz.com.fasterxml.jackson.databind.node.ValueNode;
import zz.com.fasterxml.jackson.databind.util.RawValue;

public class JsonNodeFactory
implements Serializable,
JsonNodeCreator {
    private static final long serialVersionUID = 1L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bl2) {
        this._cfgBigDecimalExact = bl2;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bl2) {
        return bl2 ? decimalsAsIs : decimalsNormalized;
    }

    @Override
    public BooleanNode booleanNode(boolean bl2) {
        return bl2 ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte by2) {
        return IntNode.valueOf(by2);
    }

    @Override
    public ValueNode numberNode(Byte by2) {
        return by2 == null ? this.nullNode() : IntNode.valueOf(by2.intValue());
    }

    @Override
    public NumericNode numberNode(short s2) {
        return ShortNode.valueOf(s2);
    }

    @Override
    public ValueNode numberNode(Short s2) {
        return s2 == null ? this.nullNode() : ShortNode.valueOf(s2);
    }

    @Override
    public NumericNode numberNode(int n2) {
        return IntNode.valueOf(n2);
    }

    @Override
    public ValueNode numberNode(Integer n2) {
        return n2 == null ? this.nullNode() : IntNode.valueOf(n2);
    }

    @Override
    public NumericNode numberNode(long l2) {
        return LongNode.valueOf(l2);
    }

    @Override
    public ValueNode numberNode(Long l2) {
        if (l2 == null) {
            return this.nullNode();
        }
        return LongNode.valueOf(l2);
    }

    @Override
    public ValueNode numberNode(BigInteger bigInteger) {
        if (bigInteger == null) {
            return this.nullNode();
        }
        return BigIntegerNode.valueOf(bigInteger);
    }

    @Override
    public NumericNode numberNode(float f2) {
        return FloatNode.valueOf(f2);
    }

    @Override
    public ValueNode numberNode(Float f2) {
        return f2 == null ? this.nullNode() : FloatNode.valueOf(f2.floatValue());
    }

    @Override
    public NumericNode numberNode(double d2) {
        return DoubleNode.valueOf(d2);
    }

    @Override
    public ValueNode numberNode(Double d2) {
        return d2 == null ? this.nullNode() : DoubleNode.valueOf(d2);
    }

    @Override
    public ValueNode numberNode(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.nullNode();
        }
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(bigDecimal);
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? DecimalNode.ZERO : DecimalNode.valueOf(bigDecimal.stripTrailingZeros());
    }

    @Override
    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray, int n2, int n3) {
        return BinaryNode.valueOf(byArray, n2, n3);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ArrayNode arrayNode(int n2) {
        return new ArrayNode(this, n2);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object object) {
        return new POJONode(object);
    }

    @Override
    public ValueNode rawValueNode(RawValue rawValue) {
        return new POJONode(rawValue);
    }

    protected boolean _inIntRange(long l2) {
        int n2 = (int)l2;
        long l3 = n2;
        return l3 == l2;
    }
}

