/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.databind.JsonSerializable;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.node.JsonNodeType;
import zz.com.fasterxml.jackson.databind.node.ValueNode;
import zz.com.fasterxml.jackson.databind.util.RawValue;

public class POJONode
extends ValueNode {
    protected final Object _value;

    public POJONode(Object object) {
        this._value = object;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.POJO;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() throws IOException {
        if (this._value instanceof byte[]) {
            return (byte[])this._value;
        }
        return super.binaryValue();
    }

    @Override
    public String asText() {
        return this._value == null ? "null" : this._value.toString();
    }

    @Override
    public String asText(String string) {
        return this._value == null ? string : this._value.toString();
    }

    @Override
    public boolean asBoolean(boolean bl2) {
        if (this._value != null && this._value instanceof Boolean) {
            return (Boolean)this._value;
        }
        return bl2;
    }

    @Override
    public int asInt(int n2) {
        if (this._value instanceof Number) {
            return ((Number)this._value).intValue();
        }
        return n2;
    }

    @Override
    public long asLong(long l2) {
        if (this._value instanceof Number) {
            return ((Number)this._value).longValue();
        }
        return l2;
    }

    @Override
    public double asDouble(double d2) {
        if (this._value instanceof Number) {
            return ((Number)this._value).doubleValue();
        }
        return d2;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._value == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else if (this._value instanceof JsonSerializable) {
            ((JsonSerializable)this._value).serialize(jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeObject(this._value);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof POJONode) {
            return this._pojoEquals((POJONode)object);
        }
        return false;
    }

    protected boolean _pojoEquals(POJONode pOJONode) {
        if (this._value == null) {
            return pOJONode._value == null;
        }
        return this._value.equals(pOJONode._value);
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }

    @Override
    public String toString() {
        if (this._value instanceof byte[]) {
            return String.format("(binary value of %d bytes)", ((byte[])this._value).length);
        }
        if (this._value instanceof RawValue) {
            return String.format("(raw value '%s')", ((RawValue)this._value).toString());
        }
        return String.valueOf(this._value);
    }
}

