/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.Base64Variant;
import zz.com.fasterxml.jackson.core.Base64Variants;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.io.CharTypes;
import zz.com.fasterxml.jackson.core.io.NumberInput;
import zz.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import zz.com.fasterxml.jackson.databind.node.JsonNodeType;
import zz.com.fasterxml.jackson.databind.node.ValueNode;

public class TextNode
extends ValueNode {
    static final TextNode EMPTY_STRING_NODE = new TextNode("");
    protected final String _value;

    public TextNode(String string) {
        this._value = string;
    }

    public static TextNode valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return EMPTY_STRING_NODE;
        }
        return new TextNode(string);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.STRING;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    @Override
    public String textValue() {
        return this._value;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        String string = this._value.trim();
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(4 + (string.length() * 3 << 2));
        try {
            base64Variant.decode(string, byteArrayBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidFormatException.from(null, String.format("Cannot access contents of TextNode as binary due to broken Base64 encoding: %s", illegalArgumentException.getMessage()), string, byte[].class);
        }
        return byteArrayBuilder.toByteArray();
    }

    @Override
    public byte[] binaryValue() throws IOException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    @Override
    public String asText() {
        return this._value;
    }

    @Override
    public String asText(String string) {
        return this._value == null ? string : this._value;
    }

    @Override
    public boolean asBoolean(boolean bl2) {
        if (this._value != null) {
            String string = this._value.trim();
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string)) {
                return false;
            }
        }
        return bl2;
    }

    @Override
    public int asInt(int n2) {
        return NumberInput.parseAsInt(this._value, n2);
    }

    @Override
    public long asLong(long l2) {
        return NumberInput.parseAsLong(this._value, l2);
    }

    @Override
    public double asDouble(double d2) {
        return NumberInput.parseAsDouble(this._value, d2);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._value == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(this._value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof TextNode) {
            return ((TextNode)object)._value.equals(this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }

    @Override
    public String toString() {
        int n2 = this._value.length();
        n2 = n2 + 2 + (n2 >> 4);
        StringBuilder stringBuilder = new StringBuilder(n2);
        TextNode.appendQuoted(stringBuilder, this._value);
        return stringBuilder.toString();
    }

    protected static void appendQuoted(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        CharTypes.appendQuoted(stringBuilder, string);
        stringBuilder.append('\"');
    }
}

