/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonTypeInfo;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.PropertyMetadata;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import zz.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import zz.com.fasterxml.jackson.databind.jsontype.NamedType;
import zz.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import zz.com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import zz.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import zz.com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import zz.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import zz.com.fasterxml.jackson.databind.ser.PropertyBuilder;
import zz.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import zz.com.fasterxml.jackson.databind.ser.SerializerFactory;
import zz.com.fasterxml.jackson.databind.ser.Serializers;
import zz.com.fasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import zz.com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import zz.com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import zz.com.fasterxml.jackson.databind.ser.std.MapSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import zz.com.fasterxml.jackson.databind.type.ReferenceType;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;
import zz.com.fasterxml.jackson.databind.util.Converter;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    protected BeanSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        super(serializerFactoryConfig);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
        if (this._factoryConfig == serializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': cannot instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(serializerFactoryConfig);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider serializerProvider, JavaType javaType) throws JsonMappingException {
        boolean bl2;
        JavaType javaType2;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        Object t2 = serializationConfig.introspect(javaType);
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, ((BeanDescription)t2).getClassInfo());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            javaType2 = javaType;
        } else {
            try {
                javaType2 = annotationIntrospector.refineSerializationType(serializationConfig, ((BeanDescription)t2).getClassInfo(), javaType);
            }
            catch (JsonMappingException jsonMappingException) {
                return (JsonSerializer)serializerProvider.reportBadTypeDefinition((BeanDescription)t2, jsonMappingException.getMessage(), new Object[0]);
            }
        }
        if (javaType2 == javaType) {
            bl2 = false;
        } else {
            bl2 = true;
            if (!javaType2.hasRawClass(javaType.getRawClass())) {
                t2 = serializationConfig.introspect(javaType2);
            }
        }
        Converter<Object, Object> converter = ((BeanDescription)t2).findSerializationConverter();
        if (converter == null) {
            return this._createSerializer2(serializerProvider, javaType2, (BeanDescription)t2, bl2);
        }
        JavaType javaType3 = converter.getOutputType(serializerProvider.getTypeFactory());
        if (!javaType3.hasRawClass(javaType2.getRawClass())) {
            t2 = serializationConfig.introspect(javaType3);
            jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, ((BeanDescription)t2).getClassInfo());
        }
        if (jsonSerializer == null && !javaType3.isJavaLangObject()) {
            jsonSerializer = this._createSerializer2(serializerProvider, javaType3, (BeanDescription)t2, true);
        }
        return new StdDelegatingSerializer(converter, javaType3, jsonSerializer);
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl2) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = null;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (javaType.isContainerType()) {
            if (!bl2) {
                bl2 = this.usesStaticTyping(serializationConfig, beanDescription, null);
            }
            if ((jsonSerializer = this.buildContainerSerializer(serializerProvider, javaType, beanDescription, bl2)) != null) {
                return jsonSerializer;
            }
        } else {
            if (javaType.isReferenceType()) {
                jsonSerializer = this.findReferenceSerializer(serializerProvider, (ReferenceType)javaType, beanDescription, bl2);
            } else {
                Serializers object;
                Iterator<Object> iterator = this.customSerializers().iterator();
                while (iterator.hasNext() && (jsonSerializer = (object = iterator.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
                }
            }
            if (jsonSerializer == null) {
                jsonSerializer = this.findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
            }
        }
        if (jsonSerializer == null && (jsonSerializer = this.findSerializerByLookup(javaType, serializationConfig, beanDescription, bl2)) == null && (jsonSerializer = this.findSerializerByPrimaryType(serializerProvider, javaType, beanDescription, bl2)) == null && (jsonSerializer = this.findBeanSerializer(serializerProvider, javaType, beanDescription)) == null && (jsonSerializer = this.findSerializerByAddonType(serializationConfig, javaType, beanDescription, bl2)) == null) {
            jsonSerializer = serializerProvider.getUnknownTypeSerializer(beanDescription.getBeanClass());
        }
        if (jsonSerializer != null && this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifySerializer(serializationConfig, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        if (!this.isPotentialBeanType(javaType.getRawClass()) && !javaType.isEnumType()) {
            return null;
        }
        return this.constructBeanSerializer(serializerProvider, beanDescription);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        TypeSerializer typeSerializer;
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType);
        } else {
            Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedMember, javaType);
            typeSerializer = typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
        }
        return typeSerializer;
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        TypeSerializer typeSerializer;
        JavaType javaType2 = javaType.getContentType();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        } else {
            Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedMember, javaType2);
            typeSerializer = typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType2, collection);
        }
        return typeSerializer;
    }

    /*
     * WARNING - void declaration
     */
    protected JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription) throws JsonMappingException {
        void var7_16;
        if (beanDescription.getBeanClass() == Object.class) {
            return serializerProvider.getUnknownTypeSerializer(Object.class);
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanSerializerBuilder beanSerializerBuilder = this.constructBeanSerializerBuilder(beanDescription);
        beanSerializerBuilder.setConfig(serializationConfig);
        List<BeanPropertyWriter> list = this.findBeanProperties(serializerProvider, beanDescription, beanSerializerBuilder);
        list = list == null ? new ArrayList<BeanPropertyWriter>() : this.removeOverlappingTypeIds(serializerProvider, beanDescription, beanSerializerBuilder, list);
        serializerProvider.getAnnotationIntrospector().findAndAddVirtualProperties(serializationConfig, beanDescription.getClassInfo(), list);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier object2 : this._factoryConfig.serializerModifiers()) {
                list = object2.changeProperties(serializationConfig, beanDescription, list);
            }
        }
        list = this.filterBeanProperties(serializationConfig, beanDescription, list);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                list = beanSerializerModifier.orderProperties(serializationConfig, beanDescription, list);
            }
        }
        beanSerializerBuilder.setObjectIdWriter(this.constructObjectIdHandler(serializerProvider, beanDescription, list));
        beanSerializerBuilder.setProperties(list);
        beanSerializerBuilder.setFilterId(this.findFilterId(serializationConfig, beanDescription));
        AnnotatedMember annotatedMember = beanDescription.findAnyGetter();
        if (annotatedMember != null) {
            JavaType javaType = annotatedMember.getType();
            boolean bl2 = serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
            JavaType javaType2 = javaType.getContentType();
            TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
            MapSerializer mapSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
            if (mapSerializer == null) {
                mapSerializer = MapSerializer.construct((Set<String>)null, javaType, bl2, typeSerializer, null, null, null);
            }
            PropertyName propertyName = PropertyName.construct(annotatedMember.getName());
            BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType2, null, annotatedMember, PropertyMetadata.STD_OPTIONAL);
            beanSerializerBuilder.setAnyGetter(new AnyGetterWriter(std, annotatedMember, mapSerializer));
        }
        this.processViews(serializationConfig, beanSerializerBuilder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                beanSerializerBuilder = beanSerializerModifier.updateBuilder(serializationConfig, beanDescription, beanSerializerBuilder);
            }
        }
        Object var7_14 = null;
        try {
            JsonSerializer<?> jsonSerializer = beanSerializerBuilder.build();
        }
        catch (RuntimeException runtimeException) {
            serializerProvider.reportBadTypeDefinition(beanDescription, "Failed to construct BeanSerializer for %s: (%s) %s", beanDescription.getType(), runtimeException.getClass().getName(), runtimeException.getMessage());
        }
        if (var7_16 == null && beanDescription.hasKnownClassAnnotations()) {
            return beanSerializerBuilder.createDummy();
        }
        return var7_16;
    }

    protected ObjectIdWriter constructObjectIdHandler(SerializerProvider serializerProvider, BeanDescription beanDescription, List<BeanPropertyWriter> list) throws JsonMappingException {
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            String string = objectIdInfo.getPropertyName().getSimpleName();
            BeanPropertyWriter beanPropertyWriter = null;
            int n2 = 0;
            int n3 = list.size();
            while (true) {
                if (n2 == n3) {
                    throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": cannot find property with name '" + string + "'");
                }
                BeanPropertyWriter beanPropertyWriter2 = list.get(n2);
                if (string.equals(beanPropertyWriter2.getName())) {
                    beanPropertyWriter = beanPropertyWriter2;
                    if (n2 <= 0) break;
                    list.remove(n2);
                    list.add(0, beanPropertyWriter);
                    break;
                }
                ++n2;
            }
            JavaType javaType = beanPropertyWriter.getType();
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo, beanPropertyWriter);
            return ObjectIdWriter.construct(javaType, null, propertyBasedObjectIdGenerator, objectIdInfo.getAlwaysAsId());
        }
        JavaType javaType = serializerProvider.constructType(clazz);
        JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
        ObjectIdGenerator<?> objectIdGenerator = serializerProvider.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        return ObjectIdWriter.construct(javaType2, objectIdInfo.getPropertyName(), objectIdGenerator, objectIdInfo.getAlwaysAsId());
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        return FilteredBeanPropertyWriter.constructViewBased(beanPropertyWriter, classArray);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return new PropertyBuilder(serializationConfig, beanDescription);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDescription) {
        return new BeanSerializerBuilder(beanDescription);
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        return ClassUtil.canBeABeanType(clazz) == null && !ClassUtil.isProxyType(clazz);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list = beanDescription.findProperties();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        this.removeIgnorableTypes(serializationConfig, beanDescription, list);
        if (serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters(serializationConfig, beanDescription, list);
        }
        if (list.isEmpty()) {
            return null;
        }
        boolean bl2 = this.usesStaticTyping(serializationConfig, beanDescription, null);
        PropertyBuilder propertyBuilder = this.constructPropertyBuilder(serializationConfig, beanDescription);
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(list.size());
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (beanPropertyDefinition.isTypeId()) {
                if (annotatedMember == null) continue;
                beanSerializerBuilder.setTypeId(annotatedMember);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty != null && referenceProperty.isBackReference()) continue;
            if (annotatedMember instanceof AnnotatedMethod) {
                arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, propertyBuilder, bl2, (AnnotatedMethod)annotatedMember));
                continue;
            }
            arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, propertyBuilder, bl2, (AnnotatedField)annotatedMember));
        }
        return arrayList;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        Set<String> set;
        JsonIgnoreProperties.Value value = serializationConfig.getDefaultPropertyIgnorals(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        if (value != null && !(set = value.findIgnoredForSerialization()).isEmpty()) {
            Iterator<BeanPropertyWriter> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!set.contains(iterator.next().getName())) continue;
                iterator.remove();
            }
        }
        return list;
    }

    protected void processViews(SerializationConfig serializationConfig, BeanSerializerBuilder beanSerializerBuilder) {
        List<BeanPropertyWriter> list = beanSerializerBuilder.getProperties();
        boolean bl2 = serializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int n2 = list.size();
        int n3 = 0;
        BeanPropertyWriter[] beanPropertyWriterArray = new BeanPropertyWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = list.get(i2);
            Class<?>[] classArray = beanPropertyWriter.getViews();
            if (classArray == null) {
                if (!bl2) continue;
                beanPropertyWriterArray[i2] = beanPropertyWriter;
                continue;
            }
            ++n3;
            beanPropertyWriterArray[i2] = this.constructFilteredBeanWriter(beanPropertyWriter, classArray);
        }
        if (bl2 && n3 == 0) {
            return;
        }
        beanSerializerBuilder.setFilteredProperties(beanPropertyWriterArray);
    }

    protected void removeIgnorableTypes(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        HashMap hashMap = new HashMap();
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (annotatedMember == null) {
                iterator.remove();
                continue;
            }
            Class<?> clazz = beanPropertyDefinition.getRawPrimaryType();
            Boolean bl2 = (Boolean)hashMap.get(clazz);
            if (bl2 == null) {
                BeanDescription beanDescription2;
                AnnotatedClass annotatedClass;
                bl2 = serializationConfig.getConfigOverride(clazz).getIsIgnoredType();
                if (bl2 == null && (bl2 = annotationIntrospector.isIgnorableType(annotatedClass = (beanDescription2 = serializationConfig.introspectClassAnnotations(clazz)).getClassInfo())) == null) {
                    bl2 = Boolean.FALSE;
                }
                hashMap.put(clazz, bl2);
            }
            if (!bl2.booleanValue()) continue;
            iterator.remove();
        }
    }

    protected void removeSetterlessGetters(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (beanPropertyDefinition.couldDeserialize() || beanPropertyDefinition.isExplicitlyIncluded()) continue;
            iterator.remove();
        }
    }

    protected List<BeanPropertyWriter> removeOverlappingTypeIds(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder, List<BeanPropertyWriter> list) {
        int n2 = list.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = list.get(i2);
            TypeSerializer typeSerializer = beanPropertyWriter.getTypeSerializer();
            if (typeSerializer == null || typeSerializer.getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            String string = typeSerializer.getPropertyName();
            PropertyName propertyName = PropertyName.construct(string);
            for (BeanPropertyWriter beanPropertyWriter2 : list) {
                if (beanPropertyWriter2 == beanPropertyWriter || !beanPropertyWriter2.wouldConflictWithName(propertyName)) continue;
                beanPropertyWriter.assignTypeSerializer(null);
                continue block0;
            }
        }
        return list;
    }

    protected BeanPropertyWriter _constructWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, PropertyBuilder propertyBuilder, boolean bl2, AnnotatedMember annotatedMember) throws JsonMappingException {
        PropertyName propertyName = beanPropertyDefinition.getFullName();
        JavaType javaType = annotatedMember.getType();
        BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType, beanPropertyDefinition.getWrapperName(), annotatedMember, beanPropertyDefinition.getMetadata());
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
        jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, std);
        TypeSerializer typeSerializer = null;
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            typeSerializer = this.findPropertyContentTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        }
        TypeSerializer typeSerializer2 = this.findPropertyTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        return propertyBuilder.buildWriter(serializerProvider, beanPropertyDefinition, javaType, jsonSerializer, typeSerializer2, typeSerializer, annotatedMember, bl2);
    }
}

