/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.impl;

import zz.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import zz.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import zz.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;

public class PropertyBasedObjectIdGenerator
extends ObjectIdGenerators.PropertyGenerator {
    private static final long serialVersionUID = 1L;
    protected final BeanPropertyWriter _property;

    public PropertyBasedObjectIdGenerator(ObjectIdInfo objectIdInfo, BeanPropertyWriter beanPropertyWriter) {
        this(objectIdInfo.getScope(), beanPropertyWriter);
    }

    protected PropertyBasedObjectIdGenerator(Class<?> clazz, BeanPropertyWriter beanPropertyWriter) {
        super(clazz);
        this._property = beanPropertyWriter;
    }

    @Override
    public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
        PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator;
        if (objectIdGenerator.getClass() == this.getClass() && (propertyBasedObjectIdGenerator = (PropertyBasedObjectIdGenerator)objectIdGenerator).getScope() == this._scope) {
            return propertyBasedObjectIdGenerator._property == this._property;
        }
        return false;
    }

    @Override
    public Object generateId(Object object) {
        try {
            return this._property.get(object);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problem accessing property '" + this._property.getName() + "': " + exception.getMessage(), exception);
        }
    }

    @Override
    public ObjectIdGenerator<Object> forScope(Class<?> clazz) {
        return clazz == this._scope ? this : new PropertyBasedObjectIdGenerator(clazz, this._property);
    }

    @Override
    public ObjectIdGenerator<Object> newForSerialization(Object object) {
        return this;
    }

    @Override
    public ObjectIdGenerator.IdKey key(Object object) {
        if (object == null) {
            return null;
        }
        return new ObjectIdGenerator.IdKey(this.getClass(), this._scope, object);
    }
}

