/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.impl;

import java.util.HashMap;
import java.util.Map;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.util.TypeKey;

public final class ReadOnlyClassToSerializerMap {
    private final Bucket[] _buckets;
    private final int _size;
    private final int _mask;

    public ReadOnlyClassToSerializerMap(Map<TypeKey, JsonSerializer<Object>> map) {
        int n2;
        this._size = n2 = ReadOnlyClassToSerializerMap.findSize(map.size());
        this._mask = n2 - 1;
        Bucket[] bucketArray = new Bucket[n2];
        for (Map.Entry<TypeKey, JsonSerializer<Object>> entry : map.entrySet()) {
            TypeKey typeKey = entry.getKey();
            int n3 = typeKey.hashCode() & this._mask;
            bucketArray[n3] = new Bucket(bucketArray[n3], typeKey, entry.getValue());
        }
        this._buckets = bucketArray;
    }

    private static final int findSize(int n2) {
        int n3;
        int n4 = n2 <= 64 ? n2 + n2 : n2 + (n2 >> 2);
        for (n3 = 8; n3 < n4; n3 += n3) {
        }
        return n3;
    }

    public static ReadOnlyClassToSerializerMap from(HashMap<TypeKey, JsonSerializer<Object>> hashMap) {
        return new ReadOnlyClassToSerializerMap(hashMap);
    }

    public int size() {
        return this._size;
    }

    public JsonSerializer<Object> typedValueSerializer(JavaType javaType) {
        Bucket bucket = this._buckets[TypeKey.typedHash(javaType) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesTyped(javaType)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesTyped(javaType)) continue;
            return bucket.value;
        }
        return null;
    }

    public JsonSerializer<Object> typedValueSerializer(Class<?> clazz) {
        Bucket bucket = this._buckets[TypeKey.typedHash(clazz) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesTyped(clazz)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesTyped(clazz)) continue;
            return bucket.value;
        }
        return null;
    }

    public JsonSerializer<Object> untypedValueSerializer(JavaType javaType) {
        Bucket bucket = this._buckets[TypeKey.untypedHash(javaType) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesUntyped(javaType)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesUntyped(javaType)) continue;
            return bucket.value;
        }
        return null;
    }

    public JsonSerializer<Object> untypedValueSerializer(Class<?> clazz) {
        Bucket bucket = this._buckets[TypeKey.untypedHash(clazz) & this._mask];
        if (bucket == null) {
            return null;
        }
        if (bucket.matchesUntyped(clazz)) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (!bucket.matchesUntyped(clazz)) continue;
            return bucket.value;
        }
        return null;
    }

    private static final class Bucket {
        public final JsonSerializer<Object> value;
        public final Bucket next;
        protected final Class<?> _class;
        protected final JavaType _type;
        protected final boolean _isTyped;

        public Bucket(Bucket bucket, TypeKey typeKey, JsonSerializer<Object> jsonSerializer) {
            this.next = bucket;
            this.value = jsonSerializer;
            this._isTyped = typeKey.isTyped();
            this._class = typeKey.getRawType();
            this._type = typeKey.getType();
        }

        public boolean matchesTyped(Class<?> clazz) {
            return this._class == clazz && this._isTyped;
        }

        public boolean matchesUntyped(Class<?> clazz) {
            return this._class == clazz && !this._isTyped;
        }

        public boolean matchesTyped(JavaType javaType) {
            return this._isTyped && javaType.equals(this._type);
        }

        public boolean matchesUntyped(JavaType javaType) {
            return !this._isTyped && javaType.equals(this._type);
        }
    }
}

