/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.SerializationFeature;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import zz.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import zz.com.fasterxml.jackson.databind.type.TypeFactory;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer stringArraySerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        super(stringArraySerializer, beanProperty, bl2);
        this._elementSerializer = jsonSerializer;
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
        return new StringArraySerializer(this, beanProperty, this._elementSerializer, bl2);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Serializable serializable;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null) {
            Object object;
            serializable = serializerProvider.getAnnotationIntrospector();
            AnnotatedMember annotatedMember = beanProperty.getMember();
            if (annotatedMember != null && (object = ((AnnotationIntrospector)serializable).findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        serializable = this.findFormatFeature(serializerProvider, beanProperty, String[].class, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            jsonSerializer = serializerProvider.findValueSerializer(String.class, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._elementSerializer && serializable == this._unwrapSingle) {
            return this;
        }
        return new StringArraySerializer(this, beanProperty, jsonSerializer, (Boolean)serializable);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, String[] stringArray) {
        return stringArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] stringArray) {
        return stringArray.length == 1;
    }

    @Override
    public final void serialize(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = stringArray.length;
        if (n2 == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(stringArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(n2);
        this.serializeContents(stringArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = stringArray.length;
        if (n2 == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(stringArray, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string == null) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeString(stringArray[i2]);
        }
    }

    private void serializeContentsSlow(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            jsonSerializer.serialize(stringArray[i2], jsonGenerator, serializerProvider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("string"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.STRING);
    }
}

