/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.std;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import zz.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import zz.com.fasterxml.jackson.core.JsonGenerationException;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.type.WritableTypeId;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.PropertyName;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import zz.com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import zz.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import zz.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import zz.com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import zz.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import zz.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import zz.com.fasterxml.jackson.databind.ser.PropertyFilter;
import zz.com.fasterxml.jackson.databind.ser.PropertyWriter;
import zz.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import zz.com.fasterxml.jackson.databind.ser.impl.MapEntrySerializer;
import zz.com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import zz.com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import zz.com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import zz.com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.databind.util.ArrayBuilders;
import zz.com.fasterxml.jackson.databind.util.Converter;
import zz.com.fasterxml.jackson.databind.util.NameTransformer;

public abstract class BeanSerializerBase
extends StdSerializer<Object>
implements JsonFormatVisitable,
SchemaAware,
ContextualSerializer,
ResolvableSerializer {
    protected static final PropertyName NAME_FOR_OBJECT_REF = new PropertyName("#object-ref");
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final JavaType _beanType;
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final AnyGetterWriter _anyGetterWriter;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;
    protected final JsonFormat.Shape _serializationShape;

    protected BeanSerializerBase(JavaType javaType, BeanSerializerBuilder beanSerializerBuilder, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(javaType);
        this._beanType = javaType;
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        if (beanSerializerBuilder == null) {
            this._typeId = null;
            this._anyGetterWriter = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
            this._serializationShape = null;
        } else {
            this._typeId = beanSerializerBuilder.getTypeId();
            this._anyGetterWriter = beanSerializerBuilder.getAnyGetter();
            this._propertyFilterId = beanSerializerBuilder.getFilterId();
            this._objectIdWriter = beanSerializerBuilder.getObjectIdWriter();
            JsonFormat.Value value = beanSerializerBuilder.getBeanDescription().findExpectedFormat(null);
            this._serializationShape = value == null ? null : value.getShape();
        }
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(beanSerializerBase._handledType);
        this._beanType = beanSerializerBase._beanType;
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter) {
        this(beanSerializerBase, objectIdWriter, beanSerializerBase._propertyFilterId);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter, Object object) {
        super(beanSerializerBase._handledType);
        this._beanType = beanSerializerBase._beanType;
        this._props = beanSerializerBase._props;
        this._filteredProps = beanSerializerBase._filteredProps;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = object;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    @Deprecated
    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        this(beanSerializerBase, ArrayBuilders.arrayToSet(stringArray));
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, Set<String> set) {
        super(beanSerializerBase._handledType);
        this._beanType = beanSerializerBase._beanType;
        BeanPropertyWriter[] beanPropertyWriterArray = beanSerializerBase._props;
        BeanPropertyWriter[] beanPropertyWriterArray2 = beanSerializerBase._filteredProps;
        int n2 = beanPropertyWriterArray.length;
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n2);
        ArrayList<BeanPropertyWriter> arrayList2 = beanPropertyWriterArray2 == null ? null : new ArrayList<BeanPropertyWriter>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i2];
            if (set != null && set.contains(beanPropertyWriter.getName())) continue;
            arrayList.add(beanPropertyWriter);
            if (beanPropertyWriterArray2 == null) continue;
            arrayList2.add(beanPropertyWriterArray2[i2]);
        }
        this._props = arrayList.toArray(new BeanPropertyWriter[arrayList.size()]);
        this._filteredProps = arrayList2 == null ? null : arrayList2.toArray(new BeanPropertyWriter[arrayList2.size()]);
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    protected abstract BeanSerializerBase withIgnorals(Set<String> var1);

    @Deprecated
    protected BeanSerializerBase withIgnorals(String[] stringArray) {
        return this.withIgnorals(ArrayBuilders.arrayToSet(stringArray));
    }

    protected abstract BeanSerializerBase asArraySerializer();

    public abstract BeanSerializerBase withFilterId(Object var1);

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase) {
        this(beanSerializerBase, beanSerializerBase._props, beanSerializerBase._filteredProps);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, NameTransformer nameTransformer) {
        this(beanSerializerBase, BeanSerializerBase.rename(beanSerializerBase._props, nameTransformer), BeanSerializerBase.rename(beanSerializerBase._filteredProps, nameTransformer));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] beanPropertyWriterArray, NameTransformer nameTransformer) {
        if (beanPropertyWriterArray == null || beanPropertyWriterArray.length == 0 || nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return beanPropertyWriterArray;
        }
        int n2 = beanPropertyWriterArray.length;
        BeanPropertyWriter[] beanPropertyWriterArray2 = new BeanPropertyWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i2];
            if (beanPropertyWriter == null) continue;
            beanPropertyWriterArray2[i2] = beanPropertyWriter.rename(nameTransformer);
        }
        return beanPropertyWriterArray2;
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        int n2 = this._filteredProps == null ? 0 : this._filteredProps.length;
        int n3 = this._props.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Serializable serializable;
            JsonSerializer<Object> jsonSerializer;
            BeanPropertyWriter beanPropertyWriter = this._props[i2];
            if (!beanPropertyWriter.willSuppressNulls() && !beanPropertyWriter.hasNullSerializer() && (jsonSerializer = serializerProvider.findNullValueSerializer(beanPropertyWriter)) != null) {
                beanPropertyWriter.assignNullSerializer(jsonSerializer);
                if (i2 < n2 && (serializable = this._filteredProps[i2]) != null) {
                    ((BeanPropertyWriter)serializable).assignNullSerializer(jsonSerializer);
                }
            }
            if (beanPropertyWriter.hasSerializer()) continue;
            jsonSerializer = this.findConvertingSerializer(serializerProvider, beanPropertyWriter);
            if (jsonSerializer == null) {
                TypeSerializer typeSerializer;
                serializable = beanPropertyWriter.getSerializationType();
                if (serializable == null && !((JavaType)(serializable = beanPropertyWriter.getType())).isFinal()) {
                    if (!((JavaType)serializable).isContainerType() && ((JavaType)serializable).containedTypeCount() <= 0) continue;
                    beanPropertyWriter.setNonTrivialBaseType((JavaType)serializable);
                    continue;
                }
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)serializable, (BeanProperty)beanPropertyWriter);
                if (((JavaType)serializable).isContainerType() && (typeSerializer = (TypeSerializer)((JavaType)serializable).getContentType().getTypeHandler()) != null && jsonSerializer instanceof ContainerSerializer) {
                    ContainerSerializer<?> containerSerializer = ((ContainerSerializer)jsonSerializer).withValueTypeSerializer(typeSerializer);
                    jsonSerializer = containerSerializer;
                }
            }
            if (i2 < n2 && (serializable = this._filteredProps[i2]) != null) {
                ((BeanPropertyWriter)serializable).assignSerializer(jsonSerializer);
                continue;
            }
            beanPropertyWriter.assignSerializer(jsonSerializer);
        }
        if (this._anyGetterWriter != null) {
            this._anyGetterWriter.resolve(serializerProvider);
        }
    }

    protected JsonSerializer<Object> findConvertingSerializer(SerializerProvider serializerProvider, BeanPropertyWriter beanPropertyWriter) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && (annotatedMember = beanPropertyWriter.getMember()) != null && (object = annotationIntrospector.findSerializationConverter(annotatedMember)) != null) {
            Converter<Object, Object> converter = serializerProvider.converterInstance(beanPropertyWriter.getMember(), object);
            JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
            JsonSerializer<Object> jsonSerializer = javaType.isJavaLangObject() ? null : serializerProvider.findValueSerializer(javaType, (BeanProperty)beanPropertyWriter);
            return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Serializable serializable;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        JsonFormat.Shape shape = null;
        if (value != null && value.hasShape() && (shape = value.getShape()) != JsonFormat.Shape.ANY && shape != this._serializationShape) {
            if (this._handledType.isEnum()) {
                switch (shape) {
                    case STRING: 
                    case NUMBER: 
                    case NUMBER_INT: {
                        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(this._beanType);
                        EnumSerializer enumSerializer = EnumSerializer.construct(this._beanType.getRawClass(), serializerProvider.getConfig(), beanDescription, value);
                        return serializerProvider.handlePrimaryContextualization(enumSerializer, beanProperty);
                    }
                }
            } else if (!(shape != JsonFormat.Shape.NATURAL || this._beanType.isMapLikeType() && Map.class.isAssignableFrom(this._handledType) || !Map.Entry.class.isAssignableFrom(this._handledType))) {
                JavaType javaType = this._beanType.findSuperType(Map.Entry.class);
                JavaType javaType2 = javaType.containedTypeOrUnknown(0);
                JavaType javaType3 = javaType.containedTypeOrUnknown(1);
                MapEntrySerializer mapEntrySerializer = new MapEntrySerializer(this._beanType, javaType2, javaType3, false, null, beanProperty);
                return serializerProvider.handlePrimaryContextualization(mapEntrySerializer, beanProperty);
            }
        }
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        Set<String> set = null;
        PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator = null;
        if (annotatedMember != null) {
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator2;
            serializable = annotationIntrospector.findPropertyIgnorals(annotatedMember);
            if (serializable != null) {
                set = ((JsonIgnoreProperties.Value)serializable).findIgnoredForSerialization();
            }
            if ((object = annotationIntrospector.findObjectIdInfo(annotatedMember)) == null) {
                if (objectIdWriter != null && (object = annotationIntrospector.findObjectReferenceInfo(annotatedMember, null)) != null) {
                    objectIdWriter = this._objectIdWriter.withAlwaysAsId(((ObjectIdInfo)object).getAlwaysAsId());
                }
            } else {
                object = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object);
                Class<? extends ObjectIdGenerator<?>> clazz = ((ObjectIdInfo)object).getGeneratorType();
                JavaType javaType = serializerProvider.constructType(clazz);
                JavaType javaType4 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
                if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
                    String string = ((ObjectIdInfo)object).getPropertyName().getSimpleName();
                    BeanPropertyWriter beanPropertyWriter = null;
                    int n2 = 0;
                    int n3 = this._props.length;
                    while (true) {
                        BeanPropertyWriter beanPropertyWriter2;
                        if (n2 == n3) {
                            serializerProvider.reportBadDefinition(this._beanType, String.format("Invalid Object Id definition for %s: cannot find property with name '%s'", this.handledType().getName(), string));
                        }
                        if (string.equals((beanPropertyWriter2 = this._props[n2]).getName())) {
                            beanPropertyWriter = beanPropertyWriter2;
                            if (n2 <= 0) break;
                            System.arraycopy(this._props, 0, this._props, 1, n2);
                            this._props[0] = beanPropertyWriter;
                            if (this._filteredProps == null) break;
                            BeanPropertyWriter beanPropertyWriter3 = this._filteredProps[n2];
                            System.arraycopy(this._filteredProps, 0, this._filteredProps, 1, n2);
                            this._filteredProps[0] = beanPropertyWriter3;
                            break;
                        }
                        ++n2;
                    }
                    javaType4 = beanPropertyWriter.getType();
                    propertyBasedObjectIdGenerator2 = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object, beanPropertyWriter);
                    objectIdWriter = ObjectIdWriter.construct(javaType4, null, propertyBasedObjectIdGenerator2, ((ObjectIdInfo)object).getAlwaysAsId());
                } else {
                    propertyBasedObjectIdGenerator2 = serializerProvider.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object);
                    objectIdWriter = ObjectIdWriter.construct(javaType4, ((ObjectIdInfo)object).getPropertyName(), propertyBasedObjectIdGenerator2, ((ObjectIdInfo)object).getAlwaysAsId());
                }
            }
            if (!((propertyBasedObjectIdGenerator2 = annotationIntrospector.findFilterId(annotatedMember)) == null || this._propertyFilterId != null && propertyBasedObjectIdGenerator2.equals(this._propertyFilterId))) {
                propertyBasedObjectIdGenerator = propertyBasedObjectIdGenerator2;
            }
        }
        serializable = this;
        if (objectIdWriter != null && (objectIdWriter = objectIdWriter.withSerializer((JsonSerializer<?>)(object = serializerProvider.findValueSerializer(objectIdWriter.idType, beanProperty)))) != this._objectIdWriter) {
            serializable = ((BeanSerializerBase)serializable).withObjectIdWriter(objectIdWriter);
        }
        if (set != null && !set.isEmpty()) {
            serializable = ((BeanSerializerBase)serializable).withIgnorals(set);
        }
        if (propertyBasedObjectIdGenerator != null) {
            serializable = ((BeanSerializerBase)serializable).withFilterId(propertyBasedObjectIdGenerator);
        }
        if (shape == null) {
            shape = this._serializationShape;
        }
        if (shape == JsonFormat.Shape.ARRAY) {
            return ((BeanSerializerBase)serializable).asArraySerializer();
        }
        return serializable;
    }

    @Override
    public Iterator<PropertyWriter> properties() {
        return Arrays.asList(this._props).iterator();
    }

    @Override
    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    @Override
    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        if (this._objectIdWriter != null) {
            jsonGenerator.setCurrentValue(object);
            this._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        jsonGenerator.setCurrentValue(object);
        WritableTypeId writableTypeId = this._typeIdDef(typeSerializer, object, JsonToken.START_OBJECT);
        typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl2) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        if (bl2) {
            jsonGenerator.writeStartObject(object);
        }
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        this._serializeObjectId(object, jsonGenerator, serializerProvider, typeSerializer, writableObjectId);
    }

    protected void _serializeObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, WritableObjectId writableObjectId) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableTypeId writableTypeId = this._typeIdDef(typeSerializer, object, JsonToken.START_OBJECT);
        typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected final WritableTypeId _typeIdDef(TypeSerializer typeSerializer, Object object, JsonToken jsonToken) {
        if (this._typeId == null) {
            return typeSerializer.typeId(object, jsonToken);
        }
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            object2 = "";
        }
        return typeSerializer.typeId(object, jsonToken, object2);
    }

    @Deprecated
    protected final String _customTypeId(Object object) {
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            return "";
        }
        return object2 instanceof String ? (String)object2 : object2.toString();
    }

    protected void serializeFields(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException((Closeable)jsonGenerator, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        PropertyFilter propertyFilter = this.findPropertyFilter(serializerProvider, this._propertyFilterId, object);
        if (propertyFilter == null) {
            this.serializeFields(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                propertyFilter.serializeAsField(object, jsonGenerator, serializerProvider, beanPropertyWriter);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndFilter(object, jsonGenerator, serializerProvider, propertyFilter);
            }
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException((Closeable)jsonGenerator, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n2].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        Object object;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        JsonSerializableSchema jsonSerializableSchema = this._handledType.getAnnotation(JsonSerializableSchema.class);
        if (jsonSerializableSchema != null && (object = jsonSerializableSchema.id()) != null && ((String)object).length() > 0) {
            objectNode.put("id", (String)object);
        }
        object = objectNode.objectNode();
        PropertyFilter propertyFilter = this._propertyFilterId != null ? this.findPropertyFilter(serializerProvider, this._propertyFilterId, null) : null;
        for (int i2 = 0; i2 < this._props.length; ++i2) {
            BeanPropertyWriter beanPropertyWriter = this._props[i2];
            if (propertyFilter == null) {
                beanPropertyWriter.depositSchemaProperty((ObjectNode)object, serializerProvider);
                continue;
            }
            propertyFilter.depositSchemaProperty((PropertyWriter)beanPropertyWriter, (ObjectNode)object, serializerProvider);
        }
        objectNode.set("properties", (JsonNode)object);
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (jsonFormatVisitorWrapper == null) {
            return;
        }
        JsonObjectFormatVisitor jsonObjectFormatVisitor = jsonFormatVisitorWrapper.expectObjectFormat(javaType);
        if (jsonObjectFormatVisitor == null) {
            return;
        }
        SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
        if (this._propertyFilterId != null) {
            PropertyFilter propertyFilter = this.findPropertyFilter(jsonFormatVisitorWrapper.getProvider(), this._propertyFilterId, null);
            int n2 = this._props.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                propertyFilter.depositSchemaProperty((PropertyWriter)this._props[i2], jsonObjectFormatVisitor, serializerProvider);
            }
        } else {
            Class<?> clazz = this._filteredProps == null || serializerProvider == null ? null : serializerProvider.getActiveView();
            for (BeanPropertyWriter beanPropertyWriter : clazz != null ? this._filteredProps : this._props) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
            }
        }
    }
}

