/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import zz.com.fasterxml.jackson.annotation.JsonFormat;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.SerializableString;
import zz.com.fasterxml.jackson.databind.BeanDescription;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.SerializationFeature;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import zz.com.fasterxml.jackson.databind.util.EnumValues;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    public EnumSerializer(EnumValues enumValues, Boolean bl2) {
        super(enumValues.getEnumClass(), false);
        this._values = enumValues;
        this._serializeAsIndex = bl2;
    }

    public static EnumSerializer construct(Class<?> clazz, SerializationConfig serializationConfig, BeanDescription beanDescription, JsonFormat.Value value) {
        EnumValues enumValues = EnumValues.constructFromName(serializationConfig, clazz);
        Boolean bl2 = EnumSerializer._isShapeWrittenUsingIndex(clazz, value, true, null);
        return new EnumSerializer(enumValues, bl2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Class clazz;
        Boolean bl2;
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        if (value != null && (bl2 = EnumSerializer._isShapeWrittenUsingIndex(clazz = this.handledType(), value, false, this._serializeAsIndex)) != this._serializeAsIndex) {
            return new EnumSerializer(this._values, bl2);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> enum_, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._serializeAsIndex(serializerProvider)) {
            jsonGenerator.writeNumber(enum_.ordinal());
            return;
        }
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            jsonGenerator.writeString(enum_.toString());
            return;
        }
        jsonGenerator.writeString(this._values.serializedValueFor(enum_));
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        JavaType javaType;
        if (this._serializeAsIndex(serializerProvider)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (type != null && (javaType = serializerProvider.constructType(type)).isEnumType()) {
            ArrayNode arrayNode = objectNode.putArray("enum");
            for (SerializableString serializableString : this._values.values()) {
                arrayNode.add(serializableString.getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
        if (this._serializeAsIndex(serializerProvider)) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.INT);
            return;
        }
        JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
        if (jsonStringFormatVisitor != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (serializerProvider != null && serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                for (Enum<?> enum_ : this._values.enums()) {
                    linkedHashSet.add(enum_.toString());
                }
            } else {
                for (SerializableString serializableString : this._values.values()) {
                    linkedHashSet.add(serializableString.getValue());
                }
            }
            jsonStringFormatVisitor.enumTypes(linkedHashSet);
        }
    }

    protected final boolean _serializeAsIndex(SerializerProvider serializerProvider) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> clazz, JsonFormat.Value value, boolean bl2, Boolean bl3) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = value == null ? null : value.getShape();
        if (shape == null) {
            return bl3;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return bl3;
        }
        if (shape == JsonFormat.Shape.STRING || shape == JsonFormat.Shape.NATURAL) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric() || shape == JsonFormat.Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(String.format("Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation", new Object[]{shape, clazz.getName(), bl2 ? "class" : "property"}));
    }
}

