/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import zz.com.fasterxml.jackson.annotation.JsonTypeInfo;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.type.WritableTypeId;
import zz.com.fasterxml.jackson.databind.BeanProperty;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.JsonSerializer;
import zz.com.fasterxml.jackson.databind.MapperFeature;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import zz.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import zz.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import zz.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class JsonValueSerializer
extends StdSerializer<Object>
implements JsonFormatVisitable,
SchemaAware,
ContextualSerializer {
    protected final AnnotatedMember _accessor;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final BeanProperty _property;
    protected final boolean _forceTypeInformation;

    public JsonValueSerializer(AnnotatedMember annotatedMember, JsonSerializer<?> jsonSerializer) {
        super(annotatedMember.getType());
        this._accessor = annotatedMember;
        this._valueSerializer = jsonSerializer;
        this._property = null;
        this._forceTypeInformation = true;
    }

    public JsonValueSerializer(JsonValueSerializer jsonValueSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, boolean bl2) {
        super(JsonValueSerializer._notNullClass(jsonValueSerializer.handledType()));
        this._accessor = jsonValueSerializer._accessor;
        this._valueSerializer = jsonSerializer;
        this._property = beanProperty;
        this._forceTypeInformation = bl2;
    }

    private static final Class<Object> _notNullClass(Class<?> clazz) {
        return clazz == null ? Object.class : clazz;
    }

    public JsonValueSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, boolean bl2) {
        if (this._property == beanProperty && this._valueSerializer == jsonSerializer && bl2 == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, beanProperty, jsonSerializer, bl2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            JavaType javaType = this._accessor.getType();
            if (serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING) || javaType.isFinal()) {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(javaType, beanProperty);
                boolean bl2 = this.isNaturalTypeWithStdHandling(javaType.getRawClass(), jsonSerializer);
                return this.withResolved(beanProperty, jsonSerializer, bl2);
            }
        } else {
            jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, beanProperty);
            return this.withResolved(beanProperty, jsonSerializer, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            Object object2 = this._accessor.getValue(object);
            if (object2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                Class<?> clazz = object2.getClass();
                jsonSerializer = serializerProvider.findTypedValueSerializer(clazz, true, this._property);
            }
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, this._accessor.getName() + "()");
        }
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        Object object2 = null;
        try {
            object2 = this._accessor.getValue(object);
            if (object2 == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = serializerProvider.findValueSerializer(object2.getClass(), this._property);
            } else if (this._forceTypeInformation) {
                WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.VALUE_STRING));
                jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
                typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
                return;
            }
            TypeSerializerRerouter typeSerializerRerouter = new TypeSerializerRerouter(typeSerializer, object);
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializerRerouter);
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, this._accessor.getName() + "()");
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        if (this._valueSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._valueSerializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JavaType javaType2 = this._accessor.getType();
        Class<?> clazz = this._accessor.getDeclaringClass();
        if (clazz != null && clazz.isEnum() && this._acceptJsonFormatVisitorForEnum(jsonFormatVisitorWrapper, javaType, clazz)) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && (jsonSerializer = jsonFormatVisitorWrapper.getProvider().findTypedValueSerializer(javaType2, false, this._property)) == null) {
            jsonFormatVisitorWrapper.expectAnyFormat(javaType);
            return;
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType2);
    }

    protected boolean _acceptJsonFormatVisitorForEnum(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, Class<?> clazz) throws JsonMappingException {
        JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
        if (jsonStringFormatVisitor != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Object obj : clazz.getEnumConstants()) {
                try {
                    linkedHashSet.add(String.valueOf(this._accessor.getValue(obj)));
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    ClassUtil.throwIfError(throwable);
                    throw JsonMappingException.wrapWithPath(throwable, obj, this._accessor.getName() + "()");
                }
            }
            jsonStringFormatVisitor.enumTypes(linkedHashSet);
        }
        return true;
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        if (clazz.isPrimitive() ? clazz != Integer.TYPE && clazz != Boolean.TYPE && clazz != Double.TYPE : clazz != String.class && clazz != Integer.class && clazz != Boolean.class && clazz != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(jsonSerializer);
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessor.getDeclaringClass() + "#" + this._accessor.getName() + ")";
    }

    static class TypeSerializerRerouter
    extends TypeSerializer {
        protected final TypeSerializer _typeSerializer;
        protected final Object _forObject;

        public TypeSerializerRerouter(TypeSerializer typeSerializer, Object object) {
            this._typeSerializer = typeSerializer;
            this._forObject = object;
        }

        @Override
        public TypeSerializer forProperty(BeanProperty beanProperty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonTypeInfo.As getTypeInclusion() {
            return this._typeSerializer.getTypeInclusion();
        }

        @Override
        public String getPropertyName() {
            return this._typeSerializer.getPropertyName();
        }

        @Override
        public TypeIdResolver getTypeIdResolver() {
            return this._typeSerializer.getTypeIdResolver();
        }

        @Override
        public WritableTypeId writeTypePrefix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
            writableTypeId.forValue = this._forObject;
            return this._typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        }

        @Override
        public WritableTypeId writeTypeSuffix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
            return this._typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
        }

        @Override
        @Deprecated
        public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
            this._typeSerializer.writeTypePrefixForScalar(this._forObject, jsonGenerator);
        }

        @Override
        @Deprecated
        public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
            this._typeSerializer.writeTypePrefixForObject(this._forObject, jsonGenerator);
        }

        @Override
        @Deprecated
        public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
            this._typeSerializer.writeTypePrefixForArray(this._forObject, jsonGenerator);
        }

        @Override
        @Deprecated
        public void writeTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
            this._typeSerializer.writeTypeSuffixForScalar(this._forObject, jsonGenerator);
        }

        @Override
        @Deprecated
        public void writeTypeSuffixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
            this._typeSerializer.writeTypeSuffixForObject(this._forObject, jsonGenerator);
        }

        @Override
        @Deprecated
        public void writeTypeSuffixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
            this._typeSerializer.writeTypeSuffixForArray(this._forObject, jsonGenerator);
        }

        @Override
        @Deprecated
        public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
            this._typeSerializer.writeTypePrefixForScalar(this._forObject, jsonGenerator, clazz);
        }

        @Override
        @Deprecated
        public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
            this._typeSerializer.writeTypePrefixForObject(this._forObject, jsonGenerator, clazz);
        }

        @Override
        @Deprecated
        public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
            this._typeSerializer.writeTypePrefixForArray(this._forObject, jsonGenerator, clazz);
        }

        @Override
        @Deprecated
        public void writeCustomTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
            this._typeSerializer.writeCustomTypePrefixForScalar(this._forObject, jsonGenerator, string);
        }

        @Override
        @Deprecated
        public void writeCustomTypePrefixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
            this._typeSerializer.writeCustomTypePrefixForObject(this._forObject, jsonGenerator, string);
        }

        @Override
        @Deprecated
        public void writeCustomTypePrefixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
            this._typeSerializer.writeCustomTypePrefixForArray(this._forObject, jsonGenerator, string);
        }

        @Override
        @Deprecated
        public void writeCustomTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
            this._typeSerializer.writeCustomTypeSuffixForScalar(this._forObject, jsonGenerator, string);
        }

        @Override
        @Deprecated
        public void writeCustomTypeSuffixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
            this._typeSerializer.writeCustomTypeSuffixForObject(this._forObject, jsonGenerator, string);
        }

        @Override
        @Deprecated
        public void writeCustomTypeSuffixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
            this._typeSerializer.writeCustomTypeSuffixForArray(this._forObject, jsonGenerator, string);
        }
    }
}

