/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.core.JsonToken;
import zz.com.fasterxml.jackson.core.type.WritableTypeId;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import zz.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import zz.com.fasterxml.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> clazz) {
        super(clazz, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        return object.toString().isEmpty();
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(object.toString());
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.VALUE_STRING));
        this.serialize(object, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this.visitStringFormat(jsonFormatVisitorWrapper, javaType);
    }
}

