/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.util.UUID;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.SerializerProvider;
import zz.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import zz.com.fasterxml.jackson.databind.util.TokenBuffer;

public class UUIDSerializer
extends StdScalarSerializer<UUID> {
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public UUIDSerializer() {
        super(UUID.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, UUID uUID) {
        return uUID.getLeastSignificantBits() == 0L && uUID.getMostSignificantBits() == 0L;
    }

    @Override
    public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (jsonGenerator.canWriteBinaryNatively() && !(jsonGenerator instanceof TokenBuffer)) {
            jsonGenerator.writeBinary(UUIDSerializer._asBytes(uUID));
            return;
        }
        char[] cArray = new char[36];
        long l2 = uUID.getMostSignificantBits();
        UUIDSerializer._appendInt((int)(l2 >> 32), cArray, 0);
        cArray[8] = 45;
        int n2 = (int)l2;
        UUIDSerializer._appendShort(n2 >>> 16, cArray, 9);
        cArray[13] = 45;
        UUIDSerializer._appendShort(n2, cArray, 14);
        cArray[18] = 45;
        long l3 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendShort((int)(l3 >>> 48), cArray, 19);
        cArray[23] = 45;
        UUIDSerializer._appendShort((int)(l3 >>> 32), cArray, 24);
        UUIDSerializer._appendInt((int)l3, cArray, 28);
        jsonGenerator.writeString(cArray, 0, 36);
    }

    private static void _appendInt(int n2, char[] cArray, int n3) {
        UUIDSerializer._appendShort(n2 >> 16, cArray, n3);
        UUIDSerializer._appendShort(n2, cArray, n3 + 4);
    }

    private static void _appendShort(int n2, char[] cArray, int n3) {
        cArray[n3] = HEX_CHARS[n2 >> 12 & 0xF];
        cArray[++n3] = HEX_CHARS[n2 >> 8 & 0xF];
        cArray[++n3] = HEX_CHARS[n2 >> 4 & 0xF];
        cArray[++n3] = HEX_CHARS[n2 & 0xF];
    }

    private static final byte[] _asBytes(UUID uUID) {
        byte[] byArray = new byte[16];
        long l2 = uUID.getMostSignificantBits();
        long l3 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendInt((int)(l2 >> 32), byArray, 0);
        UUIDSerializer._appendInt((int)l2, byArray, 4);
        UUIDSerializer._appendInt((int)(l3 >> 32), byArray, 8);
        UUIDSerializer._appendInt((int)l3, byArray, 12);
        return byArray;
    }

    private static final void _appendInt(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 24);
        byArray[++n3] = (byte)(n2 >> 16);
        byArray[++n3] = (byte)(n2 >> 8);
        byArray[++n3] = (byte)n2;
    }
}

