/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.type;

import java.util.ArrayList;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.type.ResolvedRecursiveType;

public final class ClassStack {
    protected final ClassStack _parent;
    protected final Class<?> _current;
    private ArrayList<ResolvedRecursiveType> _selfRefs;

    public ClassStack(Class<?> clazz) {
        this(null, clazz);
    }

    private ClassStack(ClassStack classStack, Class<?> clazz) {
        this._parent = classStack;
        this._current = clazz;
    }

    public ClassStack child(Class<?> clazz) {
        return new ClassStack(this, clazz);
    }

    public void addSelfReference(ResolvedRecursiveType resolvedRecursiveType) {
        if (this._selfRefs == null) {
            this._selfRefs = new ArrayList();
        }
        this._selfRefs.add(resolvedRecursiveType);
    }

    public void resolveSelfReferences(JavaType javaType) {
        if (this._selfRefs != null) {
            for (ResolvedRecursiveType resolvedRecursiveType : this._selfRefs) {
                resolvedRecursiveType.setReference(javaType);
            }
        }
    }

    public ClassStack find(Class<?> clazz) {
        if (this._current == clazz) {
            return this;
        }
        ClassStack classStack = this._parent;
        while (classStack != null) {
            if (classStack._current == clazz) {
                return classStack;
            }
            classStack = classStack._parent;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ClassStack (self-refs: ").append(this._selfRefs == null ? "0" : String.valueOf(this._selfRefs.size())).append(')');
        ClassStack classStack = this;
        while (classStack != null) {
            stringBuilder.append(' ').append(classStack._current.getName());
            classStack = classStack._parent;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

