/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMethod annotatedMethod, boolean bl2) {
        String string = annotatedMethod.getName();
        String string2 = BeanUtil.okNameForIsGetter(annotatedMethod, string, bl2);
        if (string2 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, string, bl2);
        }
        return string2;
    }

    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        if (string.startsWith("get")) {
            if ("getCallbacks".equals(string) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return bl2 ? BeanUtil.stdManglePropertyName(string, 3) : BeanUtil.legacyManglePropertyName(string, 3);
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        Class<?> clazz;
        if (string.startsWith("is") && ((clazz = annotatedMethod.getRawType()) == Boolean.class || clazz == Boolean.TYPE)) {
            return bl2 ? BeanUtil.stdManglePropertyName(string, 2) : BeanUtil.legacyManglePropertyName(string, 2);
        }
        return null;
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod annotatedMethod, boolean bl2) {
        String string = BeanUtil.okNameForMutator(annotatedMethod, "set", bl2);
        if (!(string == null || "metaClass".equals(string) && BeanUtil.isGroovyMetaClassSetter(annotatedMethod))) {
            return string;
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        String string2 = annotatedMethod.getName();
        if (string2.startsWith(string)) {
            return bl2 ? BeanUtil.stdManglePropertyName(string2, string.length()) : BeanUtil.legacyManglePropertyName(string2, string.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        Class<?> clazz2 = ClassUtil.primitiveType(clazz);
        if (clazz2 != null) {
            return ClassUtil.defaultValue(clazz2);
        }
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (clazz == String.class) {
            return "";
        }
        if (javaType.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (javaType.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(0L);
            return gregorianCalendar;
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        String string;
        Class<?> clazz2 = annotatedMethod.getRawType();
        if (clazz2.isArray() && (string = ClassUtil.getPackageName(clazz = clazz2.getComponentType())) != null && string.contains(".cglib")) {
            return string.startsWith("net.sf.cglib") || string.startsWith("zz.org.hibernate.repackage.cglib") || string.startsWith("zz.org.springframework.cglib");
        }
        return false;
    }

    protected static boolean isGroovyMetaClassSetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        String string = ClassUtil.getPackageName(clazz);
        return string != null && string.startsWith("groovy.lang");
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        String string = ClassUtil.getPackageName(annotatedMethod.getRawType());
        return string != null && string.startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c3 = string.charAt(n2);
        if (c3 == (c2 = Character.toLowerCase(c3))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c2);
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            c3 = string.charAt(i2);
            if (c3 == (c2 = Character.toLowerCase(c3))) {
                stringBuilder.append(string, i2, n3);
                break;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    protected static String stdManglePropertyName(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c3 = string.charAt(n2);
        if (c3 == (c2 = Character.toLowerCase(c3))) {
            return string.substring(n2);
        }
        if (n2 + 1 < n3 && Character.isUpperCase(string.charAt(n2 + 1))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c2);
        stringBuilder.append(string, n2 + 1, n3);
        return stringBuilder.toString();
    }
}

