/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JavaType;
import zz.com.fasterxml.jackson.databind.JsonMappingException;
import zz.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import zz.com.fasterxml.jackson.databind.annotation.NoClass;
import zz.com.fasterxml.jackson.databind.util.Named;

public final class ClassUtil {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Ctor[] NO_CTORS = new Ctor[0];
    private static final Iterator<?> EMPTY_ITERATOR = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<JavaType> findSuperTypes(JavaType javaType, Class<?> clazz, boolean bl2) {
        if (javaType == null || javaType.hasRawClass(clazz) || javaType.hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>(8);
        ClassUtil._addSuperTypes(javaType, clazz, arrayList, bl2);
        return arrayList;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        if (clazz == null || clazz == clazz2 || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(8);
        ClassUtil._addRawSuperTypes(clazz, clazz2, arrayList, bl2);
        return arrayList;
    }

    public static List<Class<?>> findSuperClasses(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        LinkedList linkedList = new LinkedList();
        if (clazz != null && clazz != clazz2) {
            if (bl2) {
                linkedList.add(clazz);
            }
            while ((clazz = clazz.getSuperclass()) != null && clazz != clazz2) {
                linkedList.add(clazz);
            }
        }
        return linkedList;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return ClassUtil.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ClassUtil._addRawSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(JavaType javaType, Class<?> clazz, Collection<JavaType> collection, boolean bl2) {
        if (javaType == null) {
            return;
        }
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 == clazz || clazz2 == Object.class) {
            return;
        }
        if (bl2) {
            if (collection.contains(javaType)) {
                return;
            }
            collection.add(javaType);
        }
        for (JavaType javaType2 : javaType.getInterfaces()) {
            ClassUtil._addSuperTypes(javaType2, clazz, collection, true);
        }
        ClassUtil._addSuperTypes(javaType.getSuperClass(), clazz, collection, true);
    }

    private static void _addRawSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl2) {
        if (clazz == clazz2 || clazz == null || clazz == Object.class) {
            return;
        }
        if (bl2) {
            if (collection.contains(clazz)) {
                return;
            }
            collection.add(clazz);
        }
        for (Class<?> clazz3 : ClassUtil._interfaces(clazz)) {
            ClassUtil._addRawSuperTypes(clazz3, clazz2, collection, true);
        }
        ClassUtil._addRawSuperTypes(clazz.getSuperclass(), clazz2, collection, true);
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (clazz.isEnum()) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl2) {
        try {
            if (ClassUtil.hasEnclosingMethod(clazz)) {
                return "local/anonymous";
            }
            if (!bl2 && !Modifier.isStatic(clazz.getModifiers()) && ClassUtil.getEnclosingClass(clazz) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        try {
            if (ClassUtil.hasEnclosingMethod(clazz)) {
                return null;
            }
            if (!Modifier.isStatic(clazz.getModifiers())) {
                return ClassUtil.getEnclosingClass(clazz);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProxyType(Class<?> clazz) {
        String string = clazz.getName();
        return string.startsWith("net.sf.cglib.proxy.") || string.startsWith("zz.org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        int n2 = clazz.getModifiers();
        return (n2 & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int n2 = member.getModifiers();
        return (n2 & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isBogusClass(Class<?> clazz) {
        return clazz == Void.class || clazz == Void.TYPE || clazz == NoClass.class;
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && ClassUtil.getEnclosingClass(clazz) != null;
    }

    public static boolean isObjectOrPrimitive(Class<?> clazz) {
        return clazz == CLS_OBJECT || clazz.isPrimitive();
    }

    public static boolean hasClass(Object object, Class<?> clazz) {
        return object != null && object.getClass() == clazz;
    }

    public static void verifyMustOverride(Class<?> clazz, Object object, String string) {
        if (object.getClass() != clazz) {
            throw new IllegalStateException(String.format("Sub-class %s (of class %s) must override method '%s'", object.getClass().getName(), clazz.getName(), string));
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable throwIfError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfRTE(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfIOE(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        return throwable;
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable throwRootCauseIfIOE(Throwable throwable) throws IOException {
        return ClassUtil.throwIfIOE(ClassUtil.getRootCause(throwable));
    }

    public static void throwAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(throwable, throwable.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        ClassUtil.throwIfRTE(throwable);
        ClassUtil.throwIfError(throwable);
        throw new IllegalArgumentException(string, throwable);
    }

    public static <T> T throwAsMappingException(DeserializationContext deserializationContext, IOException iOException) throws JsonMappingException {
        if (iOException instanceof JsonMappingException) {
            throw (JsonMappingException)iOException;
        }
        JsonMappingException jsonMappingException = JsonMappingException.from(deserializationContext, iOException.getMessage());
        jsonMappingException.initCause(iOException);
        throw jsonMappingException;
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable), string);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator jsonGenerator, Exception exception) throws IOException {
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        try {
            jsonGenerator.close();
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator jsonGenerator, Closeable closeable, Exception exception) throws IOException {
        if (jsonGenerator != null) {
            jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                jsonGenerator.close();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception3) {
                exception.addSuppressed(exception3);
            }
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl2) throws IllegalArgumentException {
        Constructor<T> constructor = ClassUtil.findConstructor(clazz, bl2);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + exception.getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl2) throws IllegalArgumentException {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl2) {
                ClassUtil.checkAndFixAccess(constructor, bl2);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception.getMessage());
        }
        return null;
    }

    public static Class<?> classOf(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public static Class<?> rawClass(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        return javaType.getRawClass();
    }

    public static <T> T nonNull(T t2, T t3) {
        return t2 == null ? t3 : t2;
    }

    public static String nullOrToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String quotedOr(Object object, String string) {
        if (object == null) {
            return string;
        }
        return String.format("\"%s\"", object);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        return ClassUtil.nameOf(clazz);
    }

    public static String classNameOf(Object object) {
        if (object == null) {
            return "[null]";
        }
        return ClassUtil.nameOf(object.getClass());
    }

    public static String nameOf(Class<?> clazz) {
        String string;
        if (clazz == null) {
            return "[null]";
        }
        int n2 = 0;
        while (clazz.isArray()) {
            ++n2;
            clazz = clazz.getComponentType();
        }
        String string2 = string = clazz.isPrimitive() ? clazz.getSimpleName() : clazz.getName();
        if (n2 > 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.append("[]");
            } while (--n2 > 0);
            string = stringBuilder.toString();
        }
        return ClassUtil.backticked(string);
    }

    public static String nameOf(Named named) {
        if (named == null) {
            return "[null]";
        }
        return ClassUtil.backticked(named.getName());
    }

    public static String backticked(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('`').append(string).append('`').toString();
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        ClassUtil.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean bl2) {
        block3: {
            AccessibleObject accessibleObject = (AccessibleObject)((Object)member);
            try {
                if (bl2 || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
                    accessibleObject.setAccessible(true);
                }
            }
            catch (SecurityException securityException) {
                if (accessibleObject.isAccessible()) break block3;
                Class<?> clazz = member.getDeclaringClass();
                throw new IllegalArgumentException("Cannot access " + member + " (from class " + clazz.getName() + "; failed to set access: " + securityException.getMessage());
            }
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumSet.iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        Class<?> clazz = enum_.getClass();
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> clazz, Class<T> clazz2) {
        Field[] fieldArray;
        for (Field field : fieldArray = ClassUtil.getDeclaredFields(clazz)) {
            T t2;
            if (!field.isEnumConstant() || (t2 = field.getAnnotation(clazz2)) == null) continue;
            String string = field.getName();
            for (Enum<?> enum_ : clazz.getEnumConstants()) {
                if (!string.equals(enum_.name())) continue;
                return enum_;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object == null || ClassUtil.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(JacksonStdImpl.class) != null;
    }

    public static String getPackageName(Class<?> clazz) {
        Package package_ = clazz.getPackage();
        return package_ == null ? null : package_.getName();
    }

    public static boolean hasEnclosingMethod(Class<?> clazz) {
        return !ClassUtil.isObjectOrPrimitive(clazz) && clazz.getEnclosingMethod() != null;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> clazz) {
        if (ClassUtil.isObjectOrPrimitive(clazz)) {
            return NO_ANNOTATIONS;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Method[] getClassMethods(Class<?> clazz) {
        try {
            return ClassUtil.getDeclaredMethods(clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Class<?> clazz2;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw noClassDefFoundError;
            }
            try {
                clazz2 = classLoader.loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                noClassDefFoundError.addSuppressed(classNotFoundException);
                throw noClassDefFoundError;
            }
            return clazz2.getDeclaredMethods();
        }
    }

    public static Ctor[] getConstructors(Class<?> clazz) {
        if (clazz.isInterface() || ClassUtil.isObjectOrPrimitive(clazz)) {
            return NO_CTORS;
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n2 = constructorArray.length;
        Ctor[] ctorArray = new Ctor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctorArray[i2] = new Ctor(constructorArray[i2]);
        }
        return ctorArray;
    }

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        return ClassUtil.isObjectOrPrimitive(clazz) ? null : clazz.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return clazz.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return ClassUtil.isObjectOrPrimitive(clazz) ? null : clazz.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }

    public static final class Ctor {
        public final Constructor<?> _ctor;
        private Annotation[] _annotations;
        private Annotation[][] _paramAnnotations;
        private int _paramCount = -1;

        public Ctor(Constructor<?> constructor) {
            this._ctor = constructor;
        }

        public Constructor<?> getConstructor() {
            return this._ctor;
        }

        public int getParamCount() {
            int n2 = this._paramCount;
            if (n2 < 0) {
                this._paramCount = n2 = this._ctor.getParameterTypes().length;
            }
            return n2;
        }

        public Class<?> getDeclaringClass() {
            return this._ctor.getDeclaringClass();
        }

        public Annotation[] getDeclaredAnnotations() {
            Annotation[] annotationArray = this._annotations;
            if (annotationArray == null) {
                annotationArray = this._ctor.getDeclaredAnnotations();
                this._annotations = annotationArray;
            }
            return annotationArray;
        }

        public Annotation[][] getParameterAnnotations() {
            Annotation[][] annotationArray = this._paramAnnotations;
            if (annotationArray == null) {
                annotationArray = this._ctor.getParameterAnnotations();
                this._paramAnnotations = annotationArray;
            }
            return annotationArray;
        }
    }

    private static class EnumTypeLocator {
        static final EnumTypeLocator instance = new EnumTypeLocator();
        private final Field enumSetTypeField = EnumTypeLocator.locateField(EnumSet.class, "elementType", Class.class);
        private final Field enumMapTypeField = EnumTypeLocator.locateField(EnumMap.class, "elementType", Class.class);

        private EnumTypeLocator() {
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumSet<?> enumSet) {
            if (this.enumSetTypeField != null) {
                return (Class)this.get(enumSet, this.enumSetTypeField);
            }
            throw new IllegalStateException("Cannot figure out type for EnumSet (odd JDK platform?)");
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumMap<?, ?> enumMap) {
            if (this.enumMapTypeField != null) {
                return (Class)this.get(enumMap, this.enumMapTypeField);
            }
            throw new IllegalStateException("Cannot figure out type for EnumMap (odd JDK platform?)");
        }

        private Object get(Object object, Field field) {
            try {
                return field.get(object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        private static Field locateField(Class<?> clazz, String string, Class<?> clazz2) {
            Field[] fieldArray;
            Field field = null;
            for (Field field2 : fieldArray = ClassUtil.getDeclaredFields(clazz)) {
                if (!string.equals(field2.getName()) || field2.getType() != clazz2) continue;
                field = field2;
                break;
            }
            if (field == null) {
                for (Field field2 : fieldArray) {
                    if (field2.getType() != clazz2) continue;
                    if (field != null) {
                        return null;
                    }
                    field = field2;
                }
            }
            if (field != null) {
                try {
                    field.setAccessible(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return field;
        }
    }
}

