/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CompactStringObjectMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final CompactStringObjectMap EMPTY = new CompactStringObjectMap(1, 0, new Object[4]);
    private final int _hashMask;
    private final int _spillCount;
    private final Object[] _hashArea;

    private CompactStringObjectMap(int n2, int n3, Object[] objectArray) {
        this._hashMask = n2;
        this._spillCount = n3;
        this._hashArea = objectArray;
    }

    public static <T> CompactStringObjectMap construct(Map<String, T> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        int n2 = CompactStringObjectMap.findSize(map.size());
        int n3 = n2 - 1;
        int n4 = (n2 + (n2 >> 1)) * 2;
        Object[] objectArray = new Object[n4];
        int n5 = 0;
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String string = entry.getKey();
            int n6 = string.hashCode() & n3;
            int n7 = n6 + n6;
            if (objectArray[n7] != null && objectArray[n7 = n2 + (n6 >> 1) << 1] != null) {
                n7 = (n2 + (n2 >> 1) << 1) + n5;
                n5 += 2;
                if (n7 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n7] = string;
            objectArray[n7 + 1] = entry.getValue();
        }
        return new CompactStringObjectMap(n3, n5, objectArray);
    }

    private static final int findSize(int n2) {
        int n3;
        if (n2 <= 5) {
            return 8;
        }
        if (n2 <= 12) {
            return 16;
        }
        int n4 = n2 + (n2 >> 2);
        for (n3 = 32; n3 < n4; n3 += n3) {
        }
        return n3;
    }

    public Object find(String string) {
        int n2 = string.hashCode() & this._hashMask;
        int n3 = n2 << 1;
        Object object = this._hashArea[n3];
        if (object == string || string.equals(object)) {
            return this._hashArea[n3 + 1];
        }
        return this._find2(string, n2, object);
    }

    private final Object _find2(String string, int n2, Object object) {
        if (object == null) {
            return null;
        }
        int n3 = this._hashMask + 1;
        int n4 = n3 + (n2 >> 1) << 1;
        object = this._hashArea[n4];
        if (string.equals(object)) {
            return this._hashArea[n4 + 1];
        }
        if (object != null) {
            int n5;
            int n6 = n5 + this._spillCount;
            for (n5 = n3 + (n3 >> 1) << 1; n5 < n6; n5 += 2) {
                object = this._hashArea[n5];
                if (object != string && !string.equals(object)) continue;
                return this._hashArea[n5 + 1];
            }
        }
        return null;
    }

    public Object findCaseInsensitive(String string) {
        int n2 = this._hashArea.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string2;
            Object object = this._hashArea[i2];
            if (object == null || !(string2 = (String)object).equalsIgnoreCase(string)) continue;
            return this._hashArea[i2 + 1];
        }
        return null;
    }

    public List<String> keys() {
        int n2 = this._hashArea.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2 >> 2);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = this._hashArea[i2];
            if (object == null) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }
}

