/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import zz.com.fasterxml.jackson.databind.AnnotationIntrospector;
import zz.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import zz.com.fasterxml.jackson.databind.util.CompactStringObjectMap;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;

    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
    }

    public static EnumResolver constructFor(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        String[] stringArray = annotationIntrospector.findEnumValues(clazz, enumArray, new String[enumArray.length]);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string == null) {
                string = enumArray[i2].name();
            }
            hashMap.put(string, enumArray[i2]);
        }
        Enum<?> enum_ = annotationIntrospector.findDefaultEnumValue(clazz);
        return new EnumResolver(clazz, enumArray, hashMap, enum_);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz) {
        return EnumResolver.constructUsingToString(clazz, null);
    }

    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(enum_.toString(), enum_);
        }
        Enum<?> enum_ = annotationIntrospector == null ? null : annotationIntrospector.findDefaultEnumValue(clazz);
        return new EnumResolver(clazz, enumArray, hashMap, enum_);
    }

    public static EnumResolver constructUsingMethod(Class<Enum<?>> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector) {
        Enum<?>[] enumArray = clazz.getEnumConstants();
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        Enum<?> enum_ = annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(clazz) : null;
        return new EnumResolver(clazz, enumArray, hashMap, enum_);
    }

    public static EnumResolver constructUnsafe(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = clazz;
        return EnumResolver.constructFor(clazz2, annotationIntrospector);
    }

    public static EnumResolver constructUnsafeUsingToString(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = clazz;
        return EnumResolver.constructUsingToString(clazz2, annotationIntrospector);
    }

    public static EnumResolver constructUnsafeUsingMethod(Class<?> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = clazz;
        return EnumResolver.constructUsingMethod(clazz2, annotatedMember, annotationIntrospector);
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    public Enum<?> findEnum(String string) {
        return this._enumsById.get(string);
    }

    public Enum<?> getEnum(int n2) {
        if (n2 < 0 || n2 >= this._enums.length) {
            return null;
        }
        return this._enums[n2];
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList arrayList = new ArrayList(this._enums.length);
        for (Enum<?> enum_ : this._enums) {
            arrayList.add(enum_);
        }
        return arrayList;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

