/*
 * Decompiled with CFR 0.152.
 */
package zz.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import zz.com.fasterxml.jackson.core.SerializableString;
import zz.com.fasterxml.jackson.databind.SerializationConfig;
import zz.com.fasterxml.jackson.databind.SerializationFeature;
import zz.com.fasterxml.jackson.databind.cfg.MapperConfig;
import zz.com.fasterxml.jackson.databind.util.ClassUtil;

public final class EnumValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;
    private transient EnumMap<?, SerializableString> _asMap;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this._enumClass = clazz;
        this._values = clazz.getEnumConstants();
        this._textual = serializableStringArray;
    }

    public static EnumValues construct(SerializationConfig serializationConfig, Class<Enum<?>> clazz) {
        if (serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(serializationConfig, clazz);
        }
        return EnumValues.constructFromName(serializationConfig, clazz);
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        String[] stringArray = mapperConfig.getAnnotationIntrospector().findEnumValues(clazz2, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return new EnumValues(clazz, serializableStringArray);
    }

    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray != null) {
            SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
            for (Enum<?> enum_ : enumArray) {
                serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(enum_.toString());
            }
            return new EnumValues(clazz, serializableStringArray);
        }
        throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
    }

    public SerializableString serializedValueFor(Enum<?> enum_) {
        return this._textual[enum_.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public EnumMap<?, SerializableString> internalMap() {
        EnumMap<Object, SerializableString> enumMap = this._asMap;
        if (enumMap == null) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Enum<?> enum_ : this._values) {
                linkedHashMap.put(enum_, this._textual[enum_.ordinal()]);
            }
            enumMap = new EnumMap(linkedHashMap);
        }
        return enumMap;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

