/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import zz.com.thoughtworks.xstream.MarshallingStrategy;
import zz.com.thoughtworks.xstream.XStreamException;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.ConverterRegistry;
import zz.com.thoughtworks.xstream.converters.DataHolder;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.SingleValueConverter;
import zz.com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import zz.com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import zz.com.thoughtworks.xstream.converters.basic.BooleanConverter;
import zz.com.thoughtworks.xstream.converters.basic.ByteConverter;
import zz.com.thoughtworks.xstream.converters.basic.CharConverter;
import zz.com.thoughtworks.xstream.converters.basic.DateConverter;
import zz.com.thoughtworks.xstream.converters.basic.DoubleConverter;
import zz.com.thoughtworks.xstream.converters.basic.FloatConverter;
import zz.com.thoughtworks.xstream.converters.basic.IntConverter;
import zz.com.thoughtworks.xstream.converters.basic.LongConverter;
import zz.com.thoughtworks.xstream.converters.basic.NullConverter;
import zz.com.thoughtworks.xstream.converters.basic.ShortConverter;
import zz.com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import zz.com.thoughtworks.xstream.converters.basic.StringConverter;
import zz.com.thoughtworks.xstream.converters.basic.URIConverter;
import zz.com.thoughtworks.xstream.converters.basic.URLConverter;
import zz.com.thoughtworks.xstream.converters.collections.ArrayConverter;
import zz.com.thoughtworks.xstream.converters.collections.BitSetConverter;
import zz.com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import zz.com.thoughtworks.xstream.converters.collections.CollectionConverter;
import zz.com.thoughtworks.xstream.converters.collections.MapConverter;
import zz.com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import zz.com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import zz.com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import zz.com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import zz.com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import zz.com.thoughtworks.xstream.converters.extended.ColorConverter;
import zz.com.thoughtworks.xstream.converters.extended.DynamicProxyConverter;
import zz.com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import zz.com.thoughtworks.xstream.converters.extended.FileConverter;
import zz.com.thoughtworks.xstream.converters.extended.FontConverter;
import zz.com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import zz.com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import zz.com.thoughtworks.xstream.converters.extended.JavaFieldConverter;
import zz.com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import zz.com.thoughtworks.xstream.converters.extended.LocaleConverter;
import zz.com.thoughtworks.xstream.converters.extended.LookAndFeelConverter;
import zz.com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import zz.com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import zz.com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import zz.com.thoughtworks.xstream.converters.extended.TextAttributeConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ExternalizableConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.DefaultConverterLookup;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.MapBackedDataHolder;
import zz.com.thoughtworks.xstream.core.ReferenceByIdMarshallingStrategy;
import zz.com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import zz.com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import zz.com.thoughtworks.xstream.core.util.CompositeClassLoader;
import zz.com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import zz.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import zz.com.thoughtworks.xstream.core.util.SelfStreamingInstanceChecker;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.io.StatefulWriter;
import zz.com.thoughtworks.xstream.io.xml.XppDriver;
import zz.com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import zz.com.thoughtworks.xstream.mapper.ArrayMapper;
import zz.com.thoughtworks.xstream.mapper.AttributeAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.AttributeMapper;
import zz.com.thoughtworks.xstream.mapper.CachingMapper;
import zz.com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import zz.com.thoughtworks.xstream.mapper.DefaultMapper;
import zz.com.thoughtworks.xstream.mapper.DynamicProxyMapper;
import zz.com.thoughtworks.xstream.mapper.ElementIgnoringMapper;
import zz.com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.ImmutableTypesMapper;
import zz.com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import zz.com.thoughtworks.xstream.mapper.LocalConversionMapper;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.mapper.MapperWrapper;
import zz.com.thoughtworks.xstream.mapper.OuterClassMapper;
import zz.com.thoughtworks.xstream.mapper.PackageAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.SecurityMapper;
import zz.com.thoughtworks.xstream.mapper.SystemAttributeAliasingMapper;
import zz.com.thoughtworks.xstream.mapper.XStream11XmlFriendlyMapper;
import zz.com.thoughtworks.xstream.security.AnyTypePermission;
import zz.com.thoughtworks.xstream.security.ArrayTypePermission;
import zz.com.thoughtworks.xstream.security.ExplicitTypePermission;
import zz.com.thoughtworks.xstream.security.InterfaceTypePermission;
import zz.com.thoughtworks.xstream.security.NoPermission;
import zz.com.thoughtworks.xstream.security.NoTypePermission;
import zz.com.thoughtworks.xstream.security.NullPermission;
import zz.com.thoughtworks.xstream.security.PrimitiveTypePermission;
import zz.com.thoughtworks.xstream.security.RegExpTypePermission;
import zz.com.thoughtworks.xstream.security.TypeHierarchyPermission;
import zz.com.thoughtworks.xstream.security.TypePermission;
import zz.com.thoughtworks.xstream.security.WildcardTypePermission;

public class XStream {
    private ReflectionProvider reflectionProvider;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private ClassLoaderReference classLoaderReference;
    private MarshallingStrategy marshallingStrategy;
    private ConverterLookup converterLookup;
    private ConverterRegistry converterRegistry;
    private Mapper mapper;
    private PackageAliasingMapper packageAliasingMapper;
    private ClassAliasingMapper classAliasingMapper;
    private FieldAliasingMapper fieldAliasingMapper;
    private ElementIgnoringMapper elementIgnoringMapper;
    private AttributeAliasingMapper attributeAliasingMapper;
    private SystemAttributeAliasingMapper systemAttributeAliasingMapper;
    private AttributeMapper attributeMapper;
    private DefaultImplementationsMapper defaultImplementationsMapper;
    private ImmutableTypesMapper immutableTypesMapper;
    private ImplicitCollectionMapper implicitCollectionMapper;
    private LocalConversionMapper localConversionMapper;
    private SecurityMapper securityMapper;
    private AnnotationConfiguration annotationConfiguration;
    private transient boolean insecureWarning;
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_RELATIVE_REFERENCES = 1003;
    public static final int XPATH_ABSOLUTE_REFERENCES = 1004;
    public static final int SINGLE_NODE_XPATH_RELATIVE_REFERENCES = 1005;
    public static final int SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES = 1006;
    public static final int PRIORITY_VERY_HIGH = 10000;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_LOW = -10;
    public static final int PRIORITY_VERY_LOW = -20;
    private static final String ANNOTATION_MAPPER_TYPE = "zz.com.thoughtworks.xstream.mapper.AnnotationMapper";
    private static final Pattern IGNORE_ALL = Pattern.compile(".*");

    public XStream() {
        this(null, (Mapper)null, new XppDriver());
    }

    public XStream(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, (Mapper)null, new XppDriver());
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(null, (Mapper)null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, (Mapper)null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, Mapper mapper, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, hierarchicalStreamDriver, new CompositeClassLoader(), mapper);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoaderReference classLoaderReference) {
        this(reflectionProvider, hierarchicalStreamDriver, classLoaderReference, null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoader classLoader) {
        this(reflectionProvider, hierarchicalStreamDriver, classLoader, null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoader classLoader, Mapper mapper) {
        this(reflectionProvider, hierarchicalStreamDriver, new ClassLoaderReference(classLoader), mapper, new DefaultConverterLookup());
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoaderReference classLoaderReference, Mapper mapper) {
        this(reflectionProvider, hierarchicalStreamDriver, classLoaderReference, mapper, new DefaultConverterLookup());
    }

    private XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoaderReference classLoaderReference, Mapper mapper, final DefaultConverterLookup defaultConverterLookup) {
        this(reflectionProvider, hierarchicalStreamDriver, classLoaderReference, mapper, new ConverterLookup(){

            public Converter lookupConverterForType(Class clazz) {
                return defaultConverterLookup.lookupConverterForType(clazz);
            }
        }, new ConverterRegistry(){

            public void registerConverter(Converter converter, int n2) {
                defaultConverterLookup.registerConverter(converter, n2);
            }
        });
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoader classLoader, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        this(reflectionProvider, hierarchicalStreamDriver, new ClassLoaderReference(classLoader), mapper, converterLookup, converterRegistry);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        if (reflectionProvider == null) {
            reflectionProvider = JVM.newReflectionProvider();
        }
        this.reflectionProvider = reflectionProvider;
        this.hierarchicalStreamDriver = hierarchicalStreamDriver;
        this.classLoaderReference = classLoaderReference;
        this.converterLookup = converterLookup;
        this.converterRegistry = converterRegistry;
        this.mapper = mapper == null ? this.buildMapper() : mapper;
        this.setupMappers();
        this.setupSecurity();
        this.setupAliases();
        this.setupDefaultImplementations();
        this.setupConverters();
        this.setupImmutableTypes();
        this.setMode(1003);
    }

    private Mapper buildMapper() {
        Mapper mapper = new DefaultMapper(this.classLoaderReference);
        if (this.useXStream11XmlFriendlyMapper()) {
            mapper = new XStream11XmlFriendlyMapper(mapper);
        }
        mapper = new DynamicProxyMapper(mapper);
        mapper = new PackageAliasingMapper(mapper);
        mapper = new ClassAliasingMapper(mapper);
        mapper = new ElementIgnoringMapper(mapper);
        mapper = new FieldAliasingMapper(mapper);
        mapper = new AttributeAliasingMapper(mapper);
        mapper = new SystemAttributeAliasingMapper(mapper);
        mapper = new ImplicitCollectionMapper(mapper, this.reflectionProvider);
        mapper = new OuterClassMapper(mapper);
        mapper = new ArrayMapper(mapper);
        mapper = new DefaultImplementationsMapper(mapper);
        mapper = new AttributeMapper(mapper, this.converterLookup, this.reflectionProvider);
        if (JVM.is15()) {
            mapper = this.buildMapperDynamically("zz.com.thoughtworks.xstream.mapper.EnumMapper", new Class[]{Mapper.class}, new Object[]{mapper});
        }
        mapper = new LocalConversionMapper(mapper);
        mapper = new ImmutableTypesMapper(mapper);
        if (JVM.is18()) {
            mapper = this.buildMapperDynamically("zz.com.thoughtworks.xstream.mapper.LambdaMapper", new Class[]{Mapper.class}, new Object[]{mapper});
        }
        mapper = new SecurityMapper(mapper);
        if (JVM.is15()) {
            mapper = this.buildMapperDynamically(ANNOTATION_MAPPER_TYPE, new Class[]{Mapper.class, ConverterRegistry.class, ConverterLookup.class, ClassLoaderReference.class, ReflectionProvider.class}, new Object[]{mapper, this.converterRegistry, this.converterLookup, this.classLoaderReference, this.reflectionProvider});
        }
        mapper = this.wrapMapper((MapperWrapper)mapper);
        mapper = new CachingMapper(mapper);
        return mapper;
    }

    private Mapper buildMapperDynamically(String string, Class[] classArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (Mapper)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new zz.com.thoughtworks.xstream.InitializationException("Could not instantiate mapper : " + string, exception);
        }
        catch (LinkageError linkageError) {
            throw new zz.com.thoughtworks.xstream.InitializationException("Could not instantiate mapper : " + string, linkageError);
        }
    }

    protected MapperWrapper wrapMapper(MapperWrapper mapperWrapper) {
        return mapperWrapper;
    }

    protected boolean useXStream11XmlFriendlyMapper() {
        return false;
    }

    private void setupMappers() {
        this.packageAliasingMapper = (PackageAliasingMapper)this.mapper.lookupMapperOfType(PackageAliasingMapper.class);
        this.classAliasingMapper = (ClassAliasingMapper)this.mapper.lookupMapperOfType(ClassAliasingMapper.class);
        this.elementIgnoringMapper = (ElementIgnoringMapper)this.mapper.lookupMapperOfType(ElementIgnoringMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.mapper.lookupMapperOfType(FieldAliasingMapper.class);
        this.attributeMapper = (AttributeMapper)this.mapper.lookupMapperOfType(AttributeMapper.class);
        this.attributeAliasingMapper = (AttributeAliasingMapper)this.mapper.lookupMapperOfType(AttributeAliasingMapper.class);
        this.systemAttributeAliasingMapper = (SystemAttributeAliasingMapper)this.mapper.lookupMapperOfType(SystemAttributeAliasingMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.mapper.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.mapper.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.immutableTypesMapper = (ImmutableTypesMapper)this.mapper.lookupMapperOfType(ImmutableTypesMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.mapper.lookupMapperOfType(LocalConversionMapper.class);
        this.securityMapper = (SecurityMapper)this.mapper.lookupMapperOfType(SecurityMapper.class);
        this.annotationConfiguration = (AnnotationConfiguration)((Object)this.mapper.lookupMapperOfType(AnnotationConfiguration.class));
    }

    protected void setupSecurity() {
        if (this.securityMapper == null) {
            return;
        }
        this.addPermission(AnyTypePermission.ANY);
        this.insecureWarning = true;
    }

    public static void setupDefaultSecurity(XStream xStream) {
        Class[] classArray;
        if (xStream.insecureWarning) {
            xStream.addPermission(NoTypePermission.NONE);
            xStream.addPermission(NullPermission.NULL);
            xStream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xStream.addPermission(ArrayTypePermission.ARRAYS);
            xStream.addPermission(InterfaceTypePermission.INTERFACES);
            xStream.allowTypeHierarchy(Calendar.class);
            xStream.allowTypeHierarchy(Collection.class);
            xStream.allowTypeHierarchy(Map.class);
            xStream.allowTypeHierarchy(Map.Entry.class);
            xStream.allowTypeHierarchy(Member.class);
            xStream.allowTypeHierarchy(Number.class);
            xStream.allowTypeHierarchy(Throwable.class);
            xStream.allowTypeHierarchy(TimeZone.class);
            Class clazz = JVM.loadClassForName("java.lang.Enum");
            if (clazz != null) {
                xStream.allowTypeHierarchy(clazz);
            }
            if ((clazz = JVM.loadClassForName("java.nio.file.Path")) != null) {
                xStream.allowTypeHierarchy(clazz);
            }
            HashSet<Class> hashSet = new HashSet<Class>();
            hashSet.add(BitSet.class);
            hashSet.add(Charset.class);
            hashSet.add(Class.class);
            hashSet.add(Currency.class);
            hashSet.add(Date.class);
            hashSet.add(DecimalFormatSymbols.class);
            hashSet.add(File.class);
            hashSet.add(Locale.class);
            hashSet.add(Object.class);
            hashSet.add(Pattern.class);
            hashSet.add(StackTraceElement.class);
            hashSet.add(String.class);
            hashSet.add(StringBuffer.class);
            hashSet.add(JVM.loadClassForName("java.lang.StringBuilder"));
            hashSet.add(URL.class);
            hashSet.add(URI.class);
            hashSet.add(JVM.loadClassForName("java.util.UUID"));
            if (JVM.isSQLAvailable()) {
                hashSet.add(JVM.loadClassForName("java.sql.Timestamp"));
                hashSet.add(JVM.loadClassForName("java.sql.Time"));
                hashSet.add(JVM.loadClassForName("java.sql.Date"));
            }
            if (JVM.is18()) {
                xStream.allowTypeHierarchy(JVM.loadClassForName("java.time.Clock"));
                hashSet.add(JVM.loadClassForName("java.time.Duration"));
                hashSet.add(JVM.loadClassForName("java.time.Instant"));
                hashSet.add(JVM.loadClassForName("java.time.LocalDate"));
                hashSet.add(JVM.loadClassForName("java.time.LocalDateTime"));
                hashSet.add(JVM.loadClassForName("java.time.LocalTime"));
                hashSet.add(JVM.loadClassForName("java.time.MonthDay"));
                hashSet.add(JVM.loadClassForName("java.time.OffsetDateTime"));
                hashSet.add(JVM.loadClassForName("java.time.OffsetTime"));
                hashSet.add(JVM.loadClassForName("java.time.Period"));
                hashSet.add(JVM.loadClassForName("java.time.Ser"));
                hashSet.add(JVM.loadClassForName("java.time.Year"));
                hashSet.add(JVM.loadClassForName("java.time.YearMonth"));
                hashSet.add(JVM.loadClassForName("java.time.ZonedDateTime"));
                xStream.allowTypeHierarchy(JVM.loadClassForName("java.time.ZoneId"));
                hashSet.add(JVM.loadClassForName("java.time.chrono.HijrahDate"));
                hashSet.add(JVM.loadClassForName("java.time.chrono.JapaneseDate"));
                hashSet.add(JVM.loadClassForName("java.time.chrono.JapaneseEra"));
                hashSet.add(JVM.loadClassForName("java.time.chrono.MinguoDate"));
                hashSet.add(JVM.loadClassForName("java.time.chrono.ThaiBuddhistDate"));
                hashSet.add(JVM.loadClassForName("java.time.chrono.Ser"));
                xStream.allowTypeHierarchy(JVM.loadClassForName("java.time.chrono.Chronology"));
                hashSet.add(JVM.loadClassForName("java.time.temporal.ValueRange"));
                hashSet.add(JVM.loadClassForName("java.time.temporal.WeekFields"));
            }
            hashSet.remove(null);
            Iterator iterator = hashSet.iterator();
            classArray = new Class[hashSet.size()];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                classArray[i2] = (Class)iterator.next();
            }
        } else {
            throw new IllegalArgumentException("Security framework of XStream instance already initialized");
        }
        xStream.allowTypes(classArray);
    }

    protected void setupAliases() {
        Class clazz;
        if (this.classAliasingMapper == null) {
            return;
        }
        this.alias("null", Mapper.Null.class);
        this.alias("int", Integer.class);
        this.alias("float", Float.class);
        this.alias("double", Double.class);
        this.alias("long", Long.class);
        this.alias("short", Short.class);
        this.alias("char", Character.class);
        this.alias("byte", Byte.class);
        this.alias("boolean", Boolean.class);
        this.alias("number", Number.class);
        this.alias("object", Object.class);
        this.alias("big-int", BigInteger.class);
        this.alias("big-decimal", BigDecimal.class);
        this.alias("string-buffer", StringBuffer.class);
        this.alias("string", String.class);
        this.alias("java-class", Class.class);
        this.alias("method", Method.class);
        this.alias("constructor", Constructor.class);
        this.alias("field", Field.class);
        this.alias("date", Date.class);
        this.alias("uri", URI.class);
        this.alias("url", URL.class);
        this.alias("bit-set", BitSet.class);
        this.alias("map", Map.class);
        this.alias("entry", Map.Entry.class);
        this.alias("properties", Properties.class);
        this.alias("list", List.class);
        this.alias("set", Set.class);
        this.alias("sorted-set", SortedSet.class);
        this.alias("linked-list", LinkedList.class);
        this.alias("vector", Vector.class);
        this.alias("tree-map", TreeMap.class);
        this.alias("tree-set", TreeSet.class);
        this.alias("hashtable", Hashtable.class);
        this.alias("empty-list", Collections.EMPTY_LIST.getClass());
        this.alias("empty-map", Collections.EMPTY_MAP.getClass());
        this.alias("empty-set", Collections.EMPTY_SET.getClass());
        this.alias("singleton-list", Collections.singletonList(this).getClass());
        this.alias("singleton-map", Collections.singletonMap(this, null).getClass());
        this.alias("singleton-set", Collections.singleton(this).getClass());
        if (JVM.isAWTAvailable()) {
            this.alias("awt-color", JVM.loadClassForName("java.awt.Color", false));
            this.alias("awt-font", JVM.loadClassForName("java.awt.Font", false));
            this.alias("awt-text-attribute", JVM.loadClassForName("java.awt.font.TextAttribute"));
        }
        if ((clazz = JVM.loadClassForName("javax.activation.ActivationDataFlavor")) != null) {
            this.alias("activation-data-flavor", clazz);
        }
        if (JVM.isSQLAvailable()) {
            this.alias("sql-timestamp", JVM.loadClassForName("java.sql.Timestamp"));
            this.alias("sql-time", JVM.loadClassForName("java.sql.Time"));
            this.alias("sql-date", JVM.loadClassForName("java.sql.Date"));
        }
        this.alias("file", File.class);
        this.alias("locale", Locale.class);
        this.alias("gregorian-calendar", Calendar.class);
        if (JVM.is14()) {
            this.aliasDynamically("auth-subject", "javax.security.auth.Subject");
            this.alias("linked-hash-map", JVM.loadClassForName("java.util.LinkedHashMap"));
            this.alias("linked-hash-set", JVM.loadClassForName("java.util.LinkedHashSet"));
            this.alias("trace", JVM.loadClassForName("java.lang.StackTraceElement"));
            this.alias("currency", JVM.loadClassForName("java.util.Currency"));
            this.aliasType("charset", JVM.loadClassForName("java.nio.charset.Charset"));
        }
        if (JVM.is15()) {
            this.aliasDynamically("xml-duration", "javax.xml.datatype.Duration");
            this.alias("concurrent-hash-map", JVM.loadClassForName("java.util.concurrent.ConcurrentHashMap"));
            this.alias("enum-set", JVM.loadClassForName("java.util.EnumSet"));
            this.alias("enum-map", JVM.loadClassForName("java.util.EnumMap"));
            this.alias("string-builder", JVM.loadClassForName("java.lang.StringBuilder"));
            this.alias("uuid", JVM.loadClassForName("java.util.UUID"));
        }
        if (JVM.is17()) {
            this.aliasType("path", JVM.loadClassForName("java.nio.file.Path"));
        }
        if (JVM.is18()) {
            this.alias("fixed-clock", JVM.loadClassForName("java.time.Clock$FixedClock"));
            this.alias("offset-clock", JVM.loadClassForName("java.time.Clock$OffsetClock"));
            this.alias("system-clock", JVM.loadClassForName("java.time.Clock$SystemClock"));
            this.alias("tick-clock", JVM.loadClassForName("java.time.Clock$TickClock"));
            this.alias("day-of-week", JVM.loadClassForName("java.time.DayOfWeek"));
            this.alias("duration", JVM.loadClassForName("java.time.Duration"));
            this.alias("instant", JVM.loadClassForName("java.time.Instant"));
            this.alias("local-date", JVM.loadClassForName("java.time.LocalDate"));
            this.alias("local-date-time", JVM.loadClassForName("java.time.LocalDateTime"));
            this.alias("local-time", JVM.loadClassForName("java.time.LocalTime"));
            this.alias("month", JVM.loadClassForName("java.time.Month"));
            this.alias("month-day", JVM.loadClassForName("java.time.MonthDay"));
            this.alias("offset-date-time", JVM.loadClassForName("java.time.OffsetDateTime"));
            this.alias("offset-time", JVM.loadClassForName("java.time.OffsetTime"));
            this.alias("period", JVM.loadClassForName("java.time.Period"));
            this.alias("year", JVM.loadClassForName("java.time.Year"));
            this.alias("year-month", JVM.loadClassForName("java.time.YearMonth"));
            this.alias("zoned-date-time", JVM.loadClassForName("java.time.ZonedDateTime"));
            this.aliasType("zone-id", JVM.loadClassForName("java.time.ZoneId"));
            this.aliasType("chronology", JVM.loadClassForName("java.time.chrono.Chronology"));
            this.alias("hijrah-date", JVM.loadClassForName("java.time.chrono.HijrahDate"));
            this.alias("hijrah-era", JVM.loadClassForName("java.time.chrono.HijrahEra"));
            this.alias("japanese-date", JVM.loadClassForName("java.time.chrono.JapaneseDate"));
            this.alias("japanese-era", JVM.loadClassForName("java.time.chrono.JapaneseEra"));
            this.alias("minguo-date", JVM.loadClassForName("java.time.chrono.MinguoDate"));
            this.alias("minguo-era", JVM.loadClassForName("java.time.chrono.MinguoEra"));
            this.alias("thai-buddhist-date", JVM.loadClassForName("java.time.chrono.ThaiBuddhistDate"));
            this.alias("thai-buddhist-era", JVM.loadClassForName("java.time.chrono.ThaiBuddhistEra"));
            this.alias("chrono-field", JVM.loadClassForName("java.time.temporal.ChronoField"));
            this.alias("chrono-unit", JVM.loadClassForName("java.time.temporal.ChronoUnit"));
            this.alias("iso-field", JVM.loadClassForName("java.time.temporal.IsoFields$Field"));
            this.alias("iso-unit", JVM.loadClassForName("java.time.temporal.IsoFields$Unit"));
            this.alias("julian-field", JVM.loadClassForName("java.time.temporal.JulianFields$Field"));
            this.alias("temporal-value-range", JVM.loadClassForName("java.time.temporal.ValueRange"));
            this.alias("week-fields", JVM.loadClassForName("java.time.temporal.WeekFields"));
        }
        if (JVM.loadClassForName("java.lang.invoke.SerializedLambda") != null) {
            this.aliasDynamically("serialized-lambda", "java.lang.invoke.SerializedLambda");
        }
    }

    private void aliasDynamically(String string, String string2) {
        Class clazz = JVM.loadClassForName(string2);
        if (clazz != null) {
            this.alias(string, clazz);
        }
    }

    protected void setupDefaultImplementations() {
        if (this.defaultImplementationsMapper == null) {
            return;
        }
        this.addDefaultImplementation(HashMap.class, Map.class);
        this.addDefaultImplementation(ArrayList.class, List.class);
        this.addDefaultImplementation(HashSet.class, Set.class);
        this.addDefaultImplementation(TreeSet.class, SortedSet.class);
        this.addDefaultImplementation(GregorianCalendar.class, Calendar.class);
    }

    protected void setupConverters() {
        this.registerConverter(new ReflectionConverter(this.mapper, this.reflectionProvider), -20);
        this.registerConverter(new SerializableConverter(this.mapper, this.reflectionProvider, this.classLoaderReference), -10);
        this.registerConverter(new ExternalizableConverter(this.mapper, this.classLoaderReference), -10);
        this.registerConverter(new InternalBlackList(), -10);
        this.registerConverter(new NullConverter(), 10000);
        this.registerConverter(new IntConverter(), 0);
        this.registerConverter(new FloatConverter(), 0);
        this.registerConverter(new DoubleConverter(), 0);
        this.registerConverter(new LongConverter(), 0);
        this.registerConverter(new ShortConverter(), 0);
        this.registerConverter(new CharConverter(), 0);
        this.registerConverter(new BooleanConverter(), 0);
        this.registerConverter(new ByteConverter(), 0);
        this.registerConverter(new StringConverter(), 0);
        this.registerConverter(new StringBufferConverter(), 0);
        this.registerConverter(new DateConverter(), 0);
        this.registerConverter(new BitSetConverter(), 0);
        this.registerConverter(new URIConverter(), 0);
        this.registerConverter(new URLConverter(), 0);
        this.registerConverter(new BigIntegerConverter(), 0);
        this.registerConverter(new BigDecimalConverter(), 0);
        this.registerConverter(new ArrayConverter(this.mapper), 0);
        this.registerConverter(new CharArrayConverter(), 0);
        this.registerConverter(new CollectionConverter(this.mapper), 0);
        this.registerConverter(new MapConverter(this.mapper), 0);
        this.registerConverter(new TreeMapConverter(this.mapper), 0);
        this.registerConverter(new TreeSetConverter(this.mapper), 0);
        this.registerConverter(new SingletonCollectionConverter(this.mapper), 0);
        this.registerConverter(new SingletonMapConverter(this.mapper), 0);
        this.registerConverter(new PropertiesConverter(), 0);
        this.registerConverter(new EncodedByteArrayConverter(), 0);
        this.registerConverter(new FileConverter(), 0);
        if (JVM.isSQLAvailable()) {
            this.registerConverter(new SqlTimestampConverter(), 0);
            this.registerConverter(new SqlTimeConverter(), 0);
            this.registerConverter(new SqlDateConverter(), 0);
        }
        this.registerConverter(new DynamicProxyConverter(this.mapper, this.classLoaderReference), 0);
        this.registerConverter(new JavaClassConverter(this.classLoaderReference), 0);
        this.registerConverter(new JavaMethodConverter(this.classLoaderReference), 0);
        this.registerConverter(new JavaFieldConverter(this.classLoaderReference), 0);
        if (JVM.isAWTAvailable()) {
            this.registerConverter(new FontConverter(this.mapper), 0);
            this.registerConverter(new ColorConverter(), 0);
            this.registerConverter(new TextAttributeConverter(), 0);
        }
        if (JVM.isSwingAvailable()) {
            this.registerConverter(new LookAndFeelConverter(this.mapper, this.reflectionProvider), 0);
        }
        this.registerConverter(new LocaleConverter(), 0);
        this.registerConverter(new GregorianCalendarConverter(), 0);
        if (JVM.is14()) {
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.SubjectConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.ThrowableConverter", 0, new Class[]{ConverterLookup.class}, new Object[]{this.converterLookup});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.StackTraceElementConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.CurrencyConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.RegexPatternConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.CharsetConverter", 0, null, null);
        }
        if (JVM.is15()) {
            if (JVM.loadClassForName("javax.xml.datatype.Duration") != null) {
                this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.DurationConverter", 0, null, null);
            }
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.enums.EnumConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.enums.EnumSetConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.enums.EnumMapConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.basic.StringBuilderConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.basic.UUIDConverter", 0, null, null);
        }
        if (JVM.loadClassForName("javax.activation.ActivationDataFlavor") != null) {
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.ActivationDataFlavorConverter", 0, null, null);
        }
        if (JVM.is17()) {
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.extended.PathConverter", 0, null, null);
        }
        if (JVM.is18()) {
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.ChronologyConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.DurationConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.HijrahDateConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.JapaneseDateConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.JapaneseEraConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.InstantConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.LocalDateConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.LocalDateTimeConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.LocalTimeConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.MinguoDateConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.MonthDayConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.OffsetDateTimeConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.OffsetTimeConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.PeriodConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.SystemClockConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.ThaiBuddhistDateConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.ValueRangeConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.WeekFieldsConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.YearConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.YearMonthConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.ZonedDateTimeConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.time.ZoneIdConverter", 0, null, null);
            this.registerConverterDynamically("zz.com.thoughtworks.xstream.converters.reflection.LambdaConverter", 0, new Class[]{Mapper.class, ReflectionProvider.class, ClassLoaderReference.class}, new Object[]{this.mapper, this.reflectionProvider, this.classLoaderReference});
        }
        this.registerConverter(new SelfStreamingInstanceChecker(this.converterLookup, (Object)this), 0);
    }

    private void registerConverterDynamically(String string, int n2, Class[] classArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            if (obj instanceof Converter) {
                this.registerConverter((Converter)obj, n2);
            } else if (obj instanceof SingleValueConverter) {
                this.registerConverter((SingleValueConverter)obj, n2);
            }
        }
        catch (Exception exception) {
            throw new zz.com.thoughtworks.xstream.InitializationException("Could not instantiate converter : " + string, exception);
        }
        catch (LinkageError linkageError) {
            throw new zz.com.thoughtworks.xstream.InitializationException("Could not instantiate converter : " + string, linkageError);
        }
    }

    protected void setupImmutableTypes() {
        Class clazz;
        if (this.immutableTypesMapper == null) {
            return;
        }
        this.addImmutableType(Boolean.TYPE, false);
        this.addImmutableType(Boolean.class, false);
        this.addImmutableType(Byte.TYPE, false);
        this.addImmutableType(Byte.class, false);
        this.addImmutableType(Character.TYPE, false);
        this.addImmutableType(Character.class, false);
        this.addImmutableType(Double.TYPE, false);
        this.addImmutableType(Double.class, false);
        this.addImmutableType(Float.TYPE, false);
        this.addImmutableType(Float.class, false);
        this.addImmutableType(Integer.TYPE, false);
        this.addImmutableType(Integer.class, false);
        this.addImmutableType(Long.TYPE, false);
        this.addImmutableType(Long.class, false);
        this.addImmutableType(Short.TYPE, false);
        this.addImmutableType(Short.class, false);
        this.addImmutableType(Mapper.Null.class, false);
        this.addImmutableType(BigDecimal.class, false);
        this.addImmutableType(BigInteger.class, false);
        this.addImmutableType(String.class, false);
        this.addImmutableType(URL.class, false);
        this.addImmutableType(File.class, false);
        this.addImmutableType(Class.class, false);
        if (JVM.is17() && (clazz = JVM.loadClassForName("java.nio.file.Paths")) != null) {
            try {
                Object object;
                Method method = clazz.getDeclaredMethod("get", String.class, String[].class);
                if (method != null && (object = method.invoke(null, ".", new String[0])) != null) {
                    this.addImmutableType(object.getClass(), false);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (JVM.isAWTAvailable()) {
            this.addImmutableTypeDynamically("java.awt.font.TextAttribute", false);
        }
        if (JVM.is14()) {
            this.addImmutableTypeDynamically("java.nio.charset.Charset", true);
            this.addImmutableTypeDynamically("java.util.Currency", true);
        }
        if (JVM.is15()) {
            this.addImmutableTypeDynamically("java.util.UUID", true);
        }
        this.addImmutableType(URI.class, true);
        this.addImmutableType(Collections.EMPTY_LIST.getClass(), true);
        this.addImmutableType(Collections.EMPTY_SET.getClass(), true);
        this.addImmutableType(Collections.EMPTY_MAP.getClass(), true);
        if (JVM.is18()) {
            this.addImmutableTypeDynamically("java.time.Duration", false);
            this.addImmutableTypeDynamically("java.time.Instant", false);
            this.addImmutableTypeDynamically("java.time.LocalDate", false);
            this.addImmutableTypeDynamically("java.time.LocalDateTime", false);
            this.addImmutableTypeDynamically("java.time.LocalTime", false);
            this.addImmutableTypeDynamically("java.time.MonthDay", false);
            this.addImmutableTypeDynamically("java.time.OffsetDateTime", false);
            this.addImmutableTypeDynamically("java.time.OffsetTime", false);
            this.addImmutableTypeDynamically("java.time.Period", false);
            this.addImmutableTypeDynamically("java.time.Year", false);
            this.addImmutableTypeDynamically("java.time.YearMonth", false);
            this.addImmutableTypeDynamically("java.time.ZonedDateTime", false);
            this.addImmutableTypeDynamically("java.time.ZoneId", false);
            this.addImmutableTypeDynamically("java.time.ZoneOffset", false);
            this.addImmutableTypeDynamically("java.time.ZoneRegion", false);
            this.addImmutableTypeDynamically("java.time.chrono.HijrahChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.HijrahDate", false);
            this.addImmutableTypeDynamically("java.time.chrono.IsoChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.JapaneseChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.JapaneseDate", false);
            this.addImmutableTypeDynamically("java.time.chrono.JapaneseEra", false);
            this.addImmutableTypeDynamically("java.time.chrono.MinguoChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.MinguoDate", false);
            this.addImmutableTypeDynamically("java.time.chrono.ThaiBuddhistChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.ThaiBuddhistDate", false);
            this.addImmutableTypeDynamically("java.time.temporal.IsoFields$Field", false);
            this.addImmutableTypeDynamically("java.time.temporal.IsoFields$Unit", false);
            this.addImmutableTypeDynamically("java.time.temporal.JulianFields$Field", false);
        }
    }

    private void addImmutableTypeDynamically(String string, boolean bl2) {
        Class clazz = JVM.loadClassForName(string);
        if (clazz != null) {
            this.addImmutableType(clazz, bl2);
        }
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public String toXML(Object object) {
        StringWriter stringWriter = new StringWriter();
        this.toXML(object, stringWriter);
        return ((Object)stringWriter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Object object, Writer writer) {
        HierarchicalStreamWriter hierarchicalStreamWriter = this.hierarchicalStreamDriver.createWriter(writer);
        try {
            this.marshal(object, hierarchicalStreamWriter);
        }
        finally {
            hierarchicalStreamWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Object object, OutputStream outputStream) {
        HierarchicalStreamWriter hierarchicalStreamWriter = this.hierarchicalStreamDriver.createWriter(outputStream);
        try {
            this.marshal(object, hierarchicalStreamWriter);
        }
        finally {
            hierarchicalStreamWriter.flush();
        }
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter) {
        this.marshal(object, hierarchicalStreamWriter, null);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, DataHolder dataHolder) {
        this.marshallingStrategy.marshal(hierarchicalStreamWriter, object, this.converterLookup, this.mapper, dataHolder);
    }

    public Object fromXML(String string) {
        return this.fromXML(new StringReader(string));
    }

    public Object fromXML(Reader reader) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(reader), null);
    }

    public Object fromXML(InputStream inputStream) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(inputStream), null);
    }

    public Object fromXML(URL uRL) {
        return this.fromXML(uRL, null);
    }

    public Object fromXML(File file) {
        return this.fromXML(file, null);
    }

    public Object fromXML(String string, Object object) {
        return this.fromXML(new StringReader(string), object);
    }

    public Object fromXML(Reader reader, Object object) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(reader), object);
    }

    public Object fromXML(URL uRL, Object object) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(uRL), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromXML(File file, Object object) {
        HierarchicalStreamReader hierarchicalStreamReader = this.hierarchicalStreamDriver.createReader(file);
        try {
            Object object2 = this.unmarshal(hierarchicalStreamReader, object);
            return object2;
        }
        finally {
            hierarchicalStreamReader.close();
        }
    }

    public Object fromXML(InputStream inputStream, Object object) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(inputStream), object);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader) {
        return this.unmarshal(hierarchicalStreamReader, null, null);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, Object object) {
        return this.unmarshal(hierarchicalStreamReader, object, null);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, Object object, DataHolder dataHolder) {
        try {
            if (this.insecureWarning) {
                this.insecureWarning = false;
                System.err.println("Security framework of XStream not initialized, XStream is probably vulnerable.");
            }
            return this.marshallingStrategy.unmarshal(object, hierarchicalStreamReader, dataHolder, this.converterLookup, this.mapper);
        }
        catch (ConversionException conversionException) {
            Package package_ = this.getClass().getPackage();
            String string = package_ != null ? package_.getImplementationVersion() : null;
            conversionException.add("version", string != null ? string : "not available");
            throw conversionException;
        }
    }

    public void alias(String string, Class clazz) {
        if (this.classAliasingMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
        }
        this.classAliasingMapper.addClassAlias(string, clazz);
    }

    public void aliasType(String string, Class clazz) {
        if (this.classAliasingMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
        }
        this.classAliasingMapper.addTypeAlias(string, clazz);
    }

    public void alias(String string, Class clazz, Class clazz2) {
        this.alias(string, clazz);
        this.addDefaultImplementation(clazz2, clazz);
    }

    public void aliasPackage(String string, String string2) {
        if (this.packageAliasingMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + PackageAliasingMapper.class.getName() + " available");
        }
        this.packageAliasingMapper.addPackageAlias(string, string2);
    }

    public void aliasField(String string, Class clazz, String string2) {
        if (this.fieldAliasingMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
        }
        this.fieldAliasingMapper.addFieldAlias(string, clazz, string2);
    }

    public void aliasAttribute(String string, String string2) {
        if (this.attributeAliasingMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + AttributeAliasingMapper.class.getName() + " available");
        }
        this.attributeAliasingMapper.addAliasFor(string2, string);
    }

    public void aliasSystemAttribute(String string, String string2) {
        if (this.systemAttributeAliasingMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + SystemAttributeAliasingMapper.class.getName() + " available");
        }
        this.systemAttributeAliasingMapper.addAliasFor(string2, string);
    }

    public void aliasAttribute(Class clazz, String string, String string2) {
        this.aliasField(string2, clazz, string);
        this.useAttributeFor(clazz, string);
    }

    public void useAttributeFor(String string, Class clazz) {
        if (this.attributeMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(string, clazz);
    }

    public void useAttributeFor(Class clazz, String string) {
        if (this.attributeMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(clazz, string);
    }

    public void useAttributeFor(Class clazz) {
        if (this.attributeMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(clazz);
    }

    public void addDefaultImplementation(Class clazz, Class clazz2) {
        if (this.defaultImplementationsMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + DefaultImplementationsMapper.class.getName() + " available");
        }
        this.defaultImplementationsMapper.addDefaultImplementation(clazz, clazz2);
    }

    public void addImmutableType(Class clazz) {
        this.addImmutableType(clazz, true);
    }

    public void addImmutableType(Class clazz, boolean bl2) {
        if (this.immutableTypesMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + ImmutableTypesMapper.class.getName() + " available");
        }
        this.immutableTypesMapper.addImmutableType(clazz, bl2);
    }

    public void registerConverter(Converter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(Converter converter, int n2) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(converter, n2);
        }
    }

    public void registerConverter(SingleValueConverter singleValueConverter) {
        this.registerConverter(singleValueConverter, 0);
    }

    public void registerConverter(SingleValueConverter singleValueConverter, int n2) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(new SingleValueConverterWrapper(singleValueConverter), n2);
        }
    }

    public void registerLocalConverter(Class clazz, String string, Converter converter) {
        if (this.localConversionMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + LocalConversionMapper.class.getName() + " available");
        }
        this.localConversionMapper.registerLocalConverter(clazz, string, converter);
    }

    public void registerLocalConverter(Class clazz, String string, SingleValueConverter singleValueConverter) {
        this.registerLocalConverter(clazz, string, new SingleValueConverterWrapper(singleValueConverter));
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public ReflectionProvider getReflectionProvider() {
        return this.reflectionProvider;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int n2) {
        switch (n2) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE));
                break;
            }
            case 1004: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE));
                break;
            }
            case 1005: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE | ReferenceByXPathMarshallingStrategy.SINGLE_NODE));
                break;
            }
            case 1006: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE | ReferenceByXPathMarshallingStrategy.SINGLE_NODE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + n2);
            }
        }
    }

    public void addImplicitCollection(Class clazz, String string) {
        this.addImplicitCollection(clazz, string, null, null);
    }

    public void addImplicitCollection(Class clazz, String string, Class clazz2) {
        this.addImplicitCollection(clazz, string, null, clazz2);
    }

    public void addImplicitCollection(Class clazz, String string, String string2, Class clazz2) {
        this.addImplicitMap(clazz, string, string2, clazz2, null);
    }

    public void addImplicitArray(Class clazz, String string) {
        this.addImplicitCollection(clazz, string);
    }

    public void addImplicitArray(Class clazz, String string, Class clazz2) {
        this.addImplicitCollection(clazz, string, clazz2);
    }

    public void addImplicitArray(Class clazz, String string, String string2) {
        this.addImplicitCollection(clazz, string, string2, null);
    }

    public void addImplicitMap(Class clazz, String string, Class clazz2, String string2) {
        this.addImplicitMap(clazz, string, null, clazz2, string2);
    }

    public void addImplicitMap(Class clazz, String string, String string2, Class clazz2, String string3) {
        if (this.implicitCollectionMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(clazz, string, string2, clazz2, string3);
    }

    public DataHolder newDataHolder() {
        return new MapBackedDataHolder();
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter hierarchicalStreamWriter) throws IOException {
        return this.createObjectOutputStream(hierarchicalStreamWriter, "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer, String string) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), string);
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream outputStream) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(outputStream), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream outputStream, String string) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(outputStream), string);
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter hierarchicalStreamWriter, String string) throws IOException {
        return this.createObjectOutputStream(hierarchicalStreamWriter, string, null);
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter hierarchicalStreamWriter, String string, final DataHolder dataHolder) throws IOException {
        final StatefulWriter statefulWriter = new StatefulWriter(hierarchicalStreamWriter);
        statefulWriter.startNode(string, null);
        return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                XStream.this.marshal(object, statefulWriter, dataHolder);
            }

            public void writeFieldsToStream(Map map) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void flush() {
                statefulWriter.flush();
            }

            public void close() {
                if (statefulWriter.state() != StatefulWriter.STATE_CLOSED) {
                    statefulWriter.endNode();
                    statefulWriter.close();
                }
            }
        });
    }

    public ObjectInputStream createObjectInputStream(Reader reader) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(reader));
    }

    public ObjectInputStream createObjectInputStream(InputStream inputStream) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(inputStream));
    }

    public ObjectInputStream createObjectInputStream(HierarchicalStreamReader hierarchicalStreamReader) throws IOException {
        return this.createObjectInputStream(hierarchicalStreamReader, null);
    }

    public ObjectInputStream createObjectInputStream(final HierarchicalStreamReader hierarchicalStreamReader, final DataHolder dataHolder) throws IOException {
        return new CustomObjectInputStream(new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() throws EOFException {
                if (!hierarchicalStreamReader.hasMoreChildren()) {
                    throw new EOFException();
                }
                hierarchicalStreamReader.moveDown();
                Object object = XStream.this.unmarshal(hierarchicalStreamReader, dataHolder);
                hierarchicalStreamReader.moveUp();
                return object;
            }

            public Map readFieldsFromStream() throws IOException {
                throw new NotActiveException("not in call to readObject");
            }

            public void defaultReadObject() throws NotActiveException {
                throw new NotActiveException("not in call to readObject");
            }

            public void registerValidation(ObjectInputValidation objectInputValidation, int n2) throws NotActiveException {
                throw new NotActiveException("stream inactive");
            }

            public void close() {
                hierarchicalStreamReader.close();
            }
        }, this.classLoaderReference);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoaderReference.setReference(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderReference.getReference();
    }

    public ClassLoaderReference getClassLoaderReference() {
        return this.classLoaderReference;
    }

    public void omitField(Class clazz, String string) {
        if (this.elementIgnoringMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + ElementIgnoringMapper.class.getName() + " available");
        }
        this.elementIgnoringMapper.omitField(clazz, string);
    }

    public void ignoreUnknownElements() {
        this.ignoreUnknownElements(IGNORE_ALL);
    }

    public void ignoreUnknownElements(String string) {
        this.ignoreUnknownElements(Pattern.compile(string));
    }

    public void ignoreUnknownElements(Pattern pattern) {
        if (this.elementIgnoringMapper == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No " + ElementIgnoringMapper.class.getName() + " available");
        }
        this.elementIgnoringMapper.addElementsToIgnore(pattern);
    }

    public void processAnnotations(Class[] classArray) {
        if (this.annotationConfiguration == null) {
            throw new zz.com.thoughtworks.xstream.InitializationException("No com.thoughtworks.xstream.mapper.AnnotationMapper available");
        }
        this.annotationConfiguration.processAnnotations(classArray);
    }

    public void processAnnotations(Class clazz) {
        this.processAnnotations(new Class[]{clazz});
    }

    public void autodetectAnnotations(boolean bl2) {
        if (this.annotationConfiguration != null) {
            this.annotationConfiguration.autodetectAnnotations(bl2);
        }
    }

    public void addPermission(TypePermission typePermission) {
        if (this.securityMapper != null) {
            this.insecureWarning &= typePermission != NoTypePermission.NONE;
            this.securityMapper.addPermission(typePermission);
        }
    }

    public void allowTypes(String[] stringArray) {
        this.addPermission(new ExplicitTypePermission(stringArray));
    }

    public void allowTypes(Class[] classArray) {
        this.addPermission(new ExplicitTypePermission(classArray));
    }

    public void allowTypeHierarchy(Class clazz) {
        this.addPermission(new TypeHierarchyPermission(clazz));
    }

    public void allowTypesByRegExp(String[] stringArray) {
        this.addPermission(new RegExpTypePermission(stringArray));
    }

    public void allowTypesByRegExp(Pattern[] patternArray) {
        this.addPermission(new RegExpTypePermission(patternArray));
    }

    public void allowTypesByWildcard(String[] stringArray) {
        this.addPermission(new WildcardTypePermission(stringArray));
    }

    public void denyPermission(TypePermission typePermission) {
        this.addPermission(new NoPermission(typePermission));
    }

    public void denyTypes(String[] stringArray) {
        this.denyPermission(new ExplicitTypePermission(stringArray));
    }

    public void denyTypes(Class[] classArray) {
        this.denyPermission(new ExplicitTypePermission(classArray));
    }

    public void denyTypeHierarchy(Class clazz) {
        this.denyPermission(new TypeHierarchyPermission(clazz));
    }

    public void denyTypesByRegExp(String[] stringArray) {
        this.denyPermission(new RegExpTypePermission(stringArray));
    }

    public void denyTypesByRegExp(Pattern[] patternArray) {
        this.denyPermission(new RegExpTypePermission(patternArray));
    }

    public void denyTypesByWildcard(String[] stringArray) {
        this.denyPermission(new WildcardTypePermission(stringArray));
    }

    private class InternalBlackList
    implements Converter {
        private InternalBlackList() {
        }

        public boolean canConvert(Class clazz) {
            return clazz == Void.TYPE || clazz == Void.class || XStream.this.insecureWarning && clazz != null && (clazz.getName().equals("java.beans.EventHandler") || clazz.getName().endsWith("$LazyIterator") || clazz.getName().startsWith("javax.crypto."));
        }

        public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
            throw new ConversionException("Security alert. Marshalling rejected.");
        }

        public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
            throw new ConversionException("Security alert. Unmarshalling rejected.");
        }
    }

    public static class InitializationException
    extends XStreamException {
        public InitializationException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InitializationException(String string) {
            super(string);
        }
    }
}

