/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.datatype.DatatypeFactory;
import zz.com.thoughtworks.xstream.MarshallingStrategy;
import zz.com.thoughtworks.xstream.XStream;
import zz.com.thoughtworks.xstream.converters.ConverterLookup;
import zz.com.thoughtworks.xstream.converters.ConverterMatcher;
import zz.com.thoughtworks.xstream.converters.ConverterRegistry;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import zz.com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.StreamException;
import zz.com.thoughtworks.xstream.io.naming.NameCoder;
import zz.com.thoughtworks.xstream.io.xml.XppDriver;
import zz.com.thoughtworks.xstream.mapper.Mapper;
import zz.com.thoughtworks.xstream.security.AnyTypePermission;
import zz.com.thoughtworks.xstream.security.TypeHierarchyPermission;
import zz.com.thoughtworks.xstream.security.TypePermission;
import zz.com.thoughtworks.xstream.security.WildcardTypePermission;

public class XStreamer {
    private static final TypePermission[] PERMISSIONS = new TypePermission[]{new TypeHierarchyPermission(ConverterMatcher.class), new TypeHierarchyPermission(Mapper.class), new TypeHierarchyPermission(XStream.class), new TypeHierarchyPermission(ReflectionProvider.class), new TypeHierarchyPermission(JavaBeanProvider.class), new TypeHierarchyPermission(FieldKeySorter.class), new TypeHierarchyPermission(ConverterLookup.class), new TypeHierarchyPermission(ConverterRegistry.class), new TypeHierarchyPermission(HierarchicalStreamDriver.class), new TypeHierarchyPermission(MarshallingStrategy.class), new TypeHierarchyPermission(MarshallingContext.class), new TypeHierarchyPermission(UnmarshallingContext.class), new TypeHierarchyPermission(NameCoder.class), new TypeHierarchyPermission(TypePermission.class), new WildcardTypePermission(new String[]{JVM.class.getPackage().getName() + ".**"}), new TypeHierarchyPermission(DatatypeFactory.class)};

    public String toXML(XStream xStream, Object object) throws ObjectStreamException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.toXML(xStream, object, stringWriter);
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            throw new StreamException("Unexpected IO error from a StringWriter", iOException);
        }
        return ((Object)stringWriter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(XStream xStream, Object object, Writer writer) throws IOException {
        XStream xStream2 = new XStream();
        XStream.setupDefaultSecurity(xStream2);
        ObjectOutputStream objectOutputStream = xStream2.createObjectOutputStream(writer);
        try {
            objectOutputStream.writeObject(xStream);
            objectOutputStream.flush();
            xStream.toXML(object, writer);
        }
        finally {
            objectOutputStream.close();
        }
    }

    public Object fromXML(String string) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(new StringReader(string));
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            throw new StreamException("Unexpected IO error from a StringReader", iOException);
        }
    }

    public Object fromXML(String string, TypePermission[] typePermissionArray) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(new StringReader(string), typePermissionArray);
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            throw new StreamException("Unexpected IO error from a StringReader", iOException);
        }
    }

    public Object fromXML(HierarchicalStreamDriver hierarchicalStreamDriver, String string) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(hierarchicalStreamDriver, new StringReader(string));
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            throw new StreamException("Unexpected IO error from a StringReader", iOException);
        }
    }

    public Object fromXML(HierarchicalStreamDriver hierarchicalStreamDriver, String string, TypePermission[] typePermissionArray) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(hierarchicalStreamDriver, new StringReader(string), typePermissionArray);
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            throw new StreamException("Unexpected IO error from a StringReader", iOException);
        }
    }

    public Object fromXML(Reader reader) throws IOException, ClassNotFoundException {
        return this.fromXML((HierarchicalStreamDriver)new XppDriver(), reader);
    }

    public Object fromXML(Reader reader, TypePermission[] typePermissionArray) throws IOException, ClassNotFoundException {
        return this.fromXML((HierarchicalStreamDriver)new XppDriver(), reader, typePermissionArray);
    }

    public Object fromXML(HierarchicalStreamDriver hierarchicalStreamDriver, Reader reader) throws IOException, ClassNotFoundException {
        return this.fromXML(hierarchicalStreamDriver, reader, new TypePermission[]{AnyTypePermission.ANY});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromXML(HierarchicalStreamDriver hierarchicalStreamDriver, Reader reader, TypePermission[] typePermissionArray) throws IOException, ClassNotFoundException {
        XStream xStream = new XStream(hierarchicalStreamDriver);
        XStream.setupDefaultSecurity(xStream);
        for (int i2 = 0; i2 < typePermissionArray.length; ++i2) {
            xStream.addPermission(typePermissionArray[i2]);
        }
        HierarchicalStreamReader hierarchicalStreamReader = hierarchicalStreamDriver.createReader(reader);
        ObjectInputStream objectInputStream = xStream.createObjectInputStream(hierarchicalStreamReader);
        try {
            Object object;
            XStream xStream2 = (XStream)objectInputStream.readObject();
            ObjectInputStream objectInputStream2 = xStream2.createObjectInputStream(hierarchicalStreamReader);
            try {
                object = objectInputStream2.readObject();
            }
            catch (Throwable throwable) {
                objectInputStream2.close();
                throw throwable;
            }
            objectInputStream2.close();
            return object;
        }
        finally {
            objectInputStream.close();
        }
    }

    public static TypePermission[] getDefaultPermissions() {
        return (TypePermission[])PERMISSIONS.clone();
    }
}

