/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.basic;

import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

public class BooleanConverter
extends AbstractSingleValueConverter {
    public static final BooleanConverter TRUE_FALSE = new BooleanConverter("true", "false", false);
    public static final BooleanConverter YES_NO = new BooleanConverter("yes", "no", false);
    public static final BooleanConverter BINARY = new BooleanConverter("1", "0", true);
    private final String positive;
    private final String negative;
    private final boolean caseSensitive;

    public BooleanConverter(String string, String string2, boolean bl2) {
        this.positive = string;
        this.negative = string2;
        this.caseSensitive = bl2;
    }

    public BooleanConverter() {
        this("true", "false", false);
    }

    public boolean shouldConvert(Class clazz, Object object) {
        return true;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    public Object fromString(String string) {
        if (this.caseSensitive) {
            return this.positive.equals(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.positive.equalsIgnoreCase(string) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString(Object object) {
        Boolean bl2 = (Boolean)object;
        return object == null ? null : (bl2 != false ? this.positive : this.negative);
    }
}

