/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.basic;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.ErrorReporter;
import zz.com.thoughtworks.xstream.converters.ErrorWriter;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.ThreadSafeSimpleDateFormat;

public class DateConverter
extends AbstractSingleValueConverter
implements ErrorReporter {
    private static final String[] DEFAULT_ACCEPTABLE_FORMATS;
    private static final String DEFAULT_PATTERN;
    private static final String DEFAULT_ERA_PATTERN;
    private static final TimeZone UTC;
    private static final long ERA_START;
    private final ThreadSafeSimpleDateFormat defaultFormat;
    private final ThreadSafeSimpleDateFormat defaultEraFormat;
    private final ThreadSafeSimpleDateFormat[] acceptableFormats;

    public DateConverter() {
        this(false);
    }

    public DateConverter(TimeZone timeZone) {
        this(DEFAULT_PATTERN, DEFAULT_ACCEPTABLE_FORMATS, timeZone);
    }

    public DateConverter(boolean bl2) {
        this(DEFAULT_PATTERN, DEFAULT_ACCEPTABLE_FORMATS, bl2);
    }

    public DateConverter(String string, String[] stringArray) {
        this(string, stringArray, false);
    }

    public DateConverter(String string, String[] stringArray, TimeZone timeZone) {
        this(string, stringArray, timeZone, false);
    }

    public DateConverter(String string, String[] stringArray, boolean bl2) {
        this(string, stringArray, UTC, bl2);
    }

    public DateConverter(String string, String[] stringArray, TimeZone timeZone, boolean bl2) {
        this(DEFAULT_ERA_PATTERN, string, stringArray, Locale.ENGLISH, timeZone, bl2);
    }

    public DateConverter(String string, String string2, String[] stringArray, Locale locale, TimeZone timeZone, boolean bl2) {
        this.defaultEraFormat = string != null ? new ThreadSafeSimpleDateFormat(string, timeZone, locale, 4, 20, bl2) : null;
        this.defaultFormat = new ThreadSafeSimpleDateFormat(string2, timeZone, locale, 4, 20, bl2);
        this.acceptableFormats = stringArray != null ? new ThreadSafeSimpleDateFormat[stringArray.length] : new ThreadSafeSimpleDateFormat[]{};
        for (int i2 = 0; i2 < this.acceptableFormats.length; ++i2) {
            this.acceptableFormats[i2] = new ThreadSafeSimpleDateFormat(stringArray[i2], timeZone, locale, 1, 20, bl2);
        }
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Date.class);
    }

    public Object fromString(String string) {
        if (this.defaultEraFormat != null) {
            try {
                return this.defaultEraFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.defaultEraFormat != this.defaultFormat) {
            try {
                return this.defaultFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        for (int i2 = 0; i2 < this.acceptableFormats.length; ++i2) {
            try {
                return this.acceptableFormats[i2].parse(string);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        ConversionException conversionException = new ConversionException("Cannot parse date");
        conversionException.add("date", string);
        throw conversionException;
    }

    public String toString(Object object) {
        Date date = (Date)object;
        if (date.getTime() < ERA_START && this.defaultEraFormat != null) {
            return this.defaultEraFormat.format(date);
        }
        return this.defaultFormat.format(date);
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("Default date pattern", this.defaultFormat.toString());
        if (this.defaultEraFormat != null) {
            errorWriter.add("Default era date pattern", this.defaultEraFormat.toString());
        }
        for (int i2 = 0; i2 < this.acceptableFormats.length; ++i2) {
            errorWriter.add("Alternative date pattern", this.acceptableFormats[i2].toString());
        }
    }

    static {
        UTC = TimeZone.getTimeZone("UTC");
        String string = "yyyy-MM-dd HH:mm:ss.S z";
        String string2 = "yyyy-MM-dd G HH:mm:ss.S z";
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = JVM.canParseUTCDateFormat();
        DEFAULT_PATTERN = bl2 ? "yyyy-MM-dd HH:mm:ss.S z" : "yyyy-MM-dd HH:mm:ss.S 'UTC'";
        DEFAULT_ERA_PATTERN = bl2 ? "yyyy-MM-dd G HH:mm:ss.S z" : "yyyy-MM-dd G HH:mm:ss.S 'UTC'";
        arrayList.add("yyyy-MM-dd HH:mm:ss.S z");
        if (!bl2) {
            arrayList.add("yyyy-MM-dd HH:mm:ss.S z");
        }
        arrayList.add("yyyy-MM-dd HH:mm:ss.S a");
        arrayList.add("yyyy-MM-dd HH:mm:ssz");
        arrayList.add("yyyy-MM-dd HH:mm:ss z");
        if (!bl2) {
            arrayList.add("yyyy-MM-dd HH:mm:ss 'UTC'");
        }
        if (JVM.canParseISO8601TimeZoneInDateFormat()) {
            arrayList.add("yyyy-MM-dd'T'HH:mm:ss.SX");
            arrayList.add("yyyy-MM-dd'T'HH:mm:ssX");
            arrayList.add("yyyy-MM-dd'T'HH:mmX");
        }
        arrayList.add("yyyy-MM-dd HH:mm:ssa");
        DEFAULT_ACCEPTABLE_FORMATS = arrayList.toArray(new String[arrayList.size()]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(UTC);
        calendar.clear();
        calendar.set(1, 0, 1);
        ERA_START = calendar.getTime().getTime();
    }
}

