/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.basic;

import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

public class LongConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class clazz) {
        return clazz.equals(Long.TYPE) || clazz.equals(Long.class);
    }

    public Object fromString(String string) {
        long l2;
        long l3;
        int n2 = string.length();
        if (n2 == 0) {
            throw new NumberFormatException("For input string: \"\"");
        }
        if (n2 < 17) {
            return Long.decode(string);
        }
        char c2 = string.charAt(0);
        if (c2 != '0' && c2 != '#') {
            return Long.decode(string);
        }
        char c3 = string.charAt(1);
        if (c2 == '#' && n2 == 17) {
            l3 = Long.parseLong(string.substring(1, 9), 16) << 32;
            l2 = Long.parseLong(string.substring(9, 17), 16);
        } else if ((c3 == 'x' || c3 == 'X') && n2 == 18) {
            l3 = Long.parseLong(string.substring(2, 10), 16) << 32;
            l2 = Long.parseLong(string.substring(10, 18), 16);
        } else if (n2 == 23 && c3 == '1') {
            l3 = Long.parseLong(string.substring(1, 12), 8) << 33;
            l2 = Long.parseLong(string.substring(12, 23), 8);
        } else {
            return Long.decode(string);
        }
        long l4 = l3 | l2;
        return new Long(l4);
    }
}

