/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.basic;

import java.util.Collections;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import zz.com.thoughtworks.xstream.core.util.WeakCache;

public class StringConverter
extends AbstractSingleValueConverter {
    private static final int LENGTH_LIMIT = 38;
    private final Map cache;
    private final int lengthLimit;

    public StringConverter(Map map, int n2) {
        this.cache = map;
        this.lengthLimit = n2;
    }

    public StringConverter(Map map) {
        this(map, 38);
    }

    public StringConverter(int n2) {
        this(Collections.synchronizedMap(new WeakCache()), n2);
    }

    public StringConverter() {
        this(38);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(String.class);
    }

    public Object fromString(String string) {
        if (this.cache != null && string != null && (this.lengthLimit < 0 || string.length() <= this.lengthLimit)) {
            String string2 = (String)this.cache.get(string);
            if (string2 == null) {
                this.cache.put(string, string);
                string2 = string;
            }
            return string2;
        }
        return string;
    }
}

