/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.ErrorWritingException;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public abstract class AbstractCollectionConverter
implements Converter {
    private final Mapper mapper;

    public abstract boolean canConvert(Class var1);

    public AbstractCollectionConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    protected Mapper mapper() {
        return this.mapper;
    }

    public abstract void marshal(Object var1, HierarchicalStreamWriter var2, MarshallingContext var3);

    public abstract Object unmarshal(HierarchicalStreamReader var1, UnmarshallingContext var2);

    protected void writeItem(Object object, MarshallingContext marshallingContext, HierarchicalStreamWriter hierarchicalStreamWriter) {
        if (object == null) {
            String string = this.mapper().serializedClass(null);
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string, Mapper.Null.class);
            hierarchicalStreamWriter.endNode();
        } else {
            String string = this.mapper().serializedClass(object.getClass());
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string, object.getClass());
            marshallingContext.convertAnother(object);
            hierarchicalStreamWriter.endNode();
        }
    }

    protected Object readItem(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Object object) {
        Class clazz = HierarchicalStreams.readClassType(hierarchicalStreamReader, this.mapper());
        return unmarshallingContext.convertAnother(object, clazz);
    }

    protected Object createCollection(Class clazz) {
        ErrorWritingException errorWritingException = null;
        Class clazz2 = this.mapper().defaultImplementationOf(clazz);
        try {
            return clazz2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            errorWritingException = new ConversionException("Cannot instantiate default collection", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            errorWritingException = new ObjectAccessException("Cannot instantiate default collection", illegalAccessException);
        }
        errorWritingException.add("collection-type", clazz.getName());
        errorWritingException.add("default-type", clazz2.getName());
        throw errorWritingException;
    }
}

