/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.util.BitSet;
import java.util.StringTokenizer;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class BitSetConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.equals(BitSet.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        BitSet bitSet = (BitSet)object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i2 = 0; i2 < bitSet.length(); ++i2) {
            if (!bitSet.get(i2)) continue;
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append(i2);
        }
        hierarchicalStreamWriter.setValue(stringBuffer.toString());
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        BitSet bitSet = new BitSet();
        StringTokenizer stringTokenizer = new StringTokenizer(hierarchicalStreamReader.getValue(), ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            bitSet.set(n2);
        }
        return bitSet;
    }
}

