/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class CollectionConverter
extends AbstractCollectionConverter {
    private final Class type;

    public CollectionConverter(Mapper mapper) {
        this(mapper, null);
    }

    public CollectionConverter(Mapper mapper, Class clazz) {
        super(mapper);
        this.type = clazz;
        if (clazz != null && !Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " not of type " + Collection.class);
        }
    }

    public boolean canConvert(Class clazz) {
        if (this.type != null) {
            return clazz.equals(this.type);
        }
        return clazz.equals(ArrayList.class) || clazz.equals(HashSet.class) || clazz.equals(LinkedList.class) || clazz.equals(Vector.class) || JVM.is14() && clazz.getName().equals("java.util.LinkedHashSet");
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Collection collection = (Collection)object;
        for (Object e2 : collection) {
            this.writeItem(e2, marshallingContext, hierarchicalStreamWriter);
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Collection collection = (Collection)this.createCollection(unmarshallingContext.getRequiredType());
        this.populateCollection(hierarchicalStreamReader, unmarshallingContext, collection);
        return collection;
    }

    protected void populateCollection(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Collection collection) {
        this.populateCollection(hierarchicalStreamReader, unmarshallingContext, collection, collection);
    }

    protected void populateCollection(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Collection collection, Collection collection2) {
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            this.addCurrentElementToCollection(hierarchicalStreamReader, unmarshallingContext, collection, collection2);
            hierarchicalStreamReader.moveUp();
        }
    }

    protected void addCurrentElementToCollection(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Collection collection, Collection collection2) {
        Object object = this.readItem(hierarchicalStreamReader, unmarshallingContext, collection);
        collection2.add(object);
    }

    protected Object createCollection(Class clazz) {
        return super.createCollection(this.type != null ? this.type : clazz);
    }
}

