/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import zz.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class MapConverter
extends AbstractCollectionConverter {
    private final Class type;

    public MapConverter(Mapper mapper) {
        this(mapper, null);
    }

    public MapConverter(Mapper mapper, Class clazz) {
        super(mapper);
        this.type = clazz;
        if (clazz != null && !Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " not of type " + Map.class);
        }
    }

    public boolean canConvert(Class clazz) {
        if (this.type != null) {
            return clazz.equals(this.type);
        }
        return clazz.equals(HashMap.class) || clazz.equals(Hashtable.class) || clazz.getName().equals("java.util.LinkedHashMap") || clazz.getName().equals("java.util.concurrent.ConcurrentHashMap") || clazz.getName().equals("sun.font.AttributeMap");
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Map map = (Map)object;
        String string = this.mapper().serializedClass(Map.Entry.class);
        for (Map.Entry entry : map.entrySet()) {
            ExtendedHierarchicalStreamWriterHelper.startNode(hierarchicalStreamWriter, string, entry.getClass());
            this.writeItem(entry.getKey(), marshallingContext, hierarchicalStreamWriter);
            this.writeItem(entry.getValue(), marshallingContext, hierarchicalStreamWriter);
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Map map = (Map)this.createCollection(unmarshallingContext.getRequiredType());
        this.populateMap(hierarchicalStreamReader, unmarshallingContext, map);
        return map;
    }

    protected void populateMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Map map) {
        this.populateMap(hierarchicalStreamReader, unmarshallingContext, map, map);
    }

    protected void populateMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Map map, Map map2) {
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            this.putCurrentEntryIntoMap(hierarchicalStreamReader, unmarshallingContext, map, map2);
            hierarchicalStreamReader.moveUp();
        }
    }

    protected void putCurrentEntryIntoMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Map map, Map map2) {
        hierarchicalStreamReader.moveDown();
        Object object = this.readItem(hierarchicalStreamReader, unmarshallingContext, map);
        hierarchicalStreamReader.moveUp();
        hierarchicalStreamReader.moveDown();
        Object object2 = this.readItem(hierarchicalStreamReader, unmarshallingContext, map);
        hierarchicalStreamReader.moveUp();
        map2.put(object, object2);
    }

    protected Object createCollection(Class clazz) {
        return super.createCollection(this.type != null ? this.type : clazz);
    }
}

