/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class PropertiesConverter
implements Converter {
    private static final Field defaultsField = Fields.locate(Properties.class, Properties.class, false);
    private final boolean sort;

    public PropertiesConverter() {
        this(false);
    }

    public PropertiesConverter(boolean bl2) {
        this.sort = bl2;
    }

    public boolean canConvert(Class clazz) {
        return Properties.class == clazz;
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Properties properties = (Properties)object;
        Map<Object, Object> map = this.sort ? new TreeMap<Object, Object>(properties) : properties;
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<Object, Object> entry = object2.next();
            hierarchicalStreamWriter.startNode("property");
            hierarchicalStreamWriter.addAttribute("name", entry.getKey().toString());
            hierarchicalStreamWriter.addAttribute("value", entry.getValue().toString());
            hierarchicalStreamWriter.endNode();
        }
        if (defaultsField != null && (object2 = (Properties)Fields.read(defaultsField, properties)) != null) {
            hierarchicalStreamWriter.startNode("defaults");
            this.marshal(object2, hierarchicalStreamWriter, marshallingContext);
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Object object;
        Properties properties = new Properties();
        Properties properties2 = null;
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            if (hierarchicalStreamReader.getNodeName().equals("defaults")) {
                properties2 = (Properties)this.unmarshal(hierarchicalStreamReader, unmarshallingContext);
            } else {
                object = hierarchicalStreamReader.getAttribute("name");
                String string = hierarchicalStreamReader.getAttribute("value");
                properties.setProperty((String)object, string);
            }
            hierarchicalStreamReader.moveUp();
        }
        if (properties2 == null) {
            return properties;
        }
        object = new Properties(properties2);
        ((Properties)object).putAll((Map<?, ?>)properties);
        return object;
    }
}

