/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.util.Collections;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.CollectionConverter;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class SingletonCollectionConverter
extends CollectionConverter {
    private static final Class LIST = Collections.singletonList(Boolean.TRUE).getClass();
    private static final Class SET = Collections.singleton(Boolean.TRUE).getClass();

    public SingletonCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class clazz) {
        return LIST == clazz || SET == clazz;
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        hierarchicalStreamReader.moveDown();
        Object object = this.readItem(hierarchicalStreamReader, unmarshallingContext, null);
        hierarchicalStreamReader.moveUp();
        return unmarshallingContext.getRequiredType() == LIST ? Collections.singletonList(object) : Collections.singleton(object);
    }
}

