/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.MapConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import zz.com.thoughtworks.xstream.core.util.PresortedMap;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class TreeMapConverter
extends MapConverter {
    private static final Comparator NULL_MARKER = new NullComparator();
    private static final Field comparatorField = Fields.locate(TreeMap.class, Comparator.class, false);

    public TreeMapConverter(Mapper mapper) {
        super(mapper, TreeMap.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        SortedMap sortedMap = (SortedMap)object;
        this.marshalComparator(sortedMap.comparator(), hierarchicalStreamWriter, marshallingContext);
        super.marshal(object, hierarchicalStreamWriter, marshallingContext);
    }

    protected void marshalComparator(Comparator comparator, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        if (comparator != null) {
            hierarchicalStreamWriter.startNode("comparator");
            hierarchicalStreamWriter.addAttribute(this.mapper().aliasForSystemAttribute("class"), this.mapper().serializedClass(comparator.getClass()));
            marshallingContext.convertAnother(comparator);
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        TreeMap treeMap = comparatorField != null ? new TreeMap() : null;
        Comparator comparator = this.unmarshalComparator(hierarchicalStreamReader, unmarshallingContext, treeMap);
        if (treeMap == null) {
            treeMap = comparator == null ? new TreeMap() : new TreeMap(comparator);
        }
        this.populateTreeMap(hierarchicalStreamReader, unmarshallingContext, treeMap, comparator);
        return treeMap;
    }

    protected Comparator unmarshalComparator(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, TreeMap treeMap) {
        Comparator comparator;
        if (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            if (hierarchicalStreamReader.getNodeName().equals("comparator")) {
                Class clazz = HierarchicalStreams.readClassType(hierarchicalStreamReader, this.mapper());
                comparator = (Comparator)unmarshallingContext.convertAnother(treeMap, clazz);
            } else if (hierarchicalStreamReader.getNodeName().equals("no-comparator")) {
                comparator = null;
            } else {
                return NULL_MARKER;
            }
            hierarchicalStreamReader.moveUp();
        } else {
            comparator = null;
        }
        return comparator;
    }

    protected void populateTreeMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, TreeMap treeMap, Comparator comparator) {
        boolean bl2;
        boolean bl3 = bl2 = comparator == NULL_MARKER;
        if (bl2) {
            comparator = null;
        }
        PresortedMap presortedMap = new PresortedMap(comparator != null && JVM.hasOptimizedTreeMapPutAll() ? comparator : null);
        if (bl2) {
            this.putCurrentEntryIntoMap(hierarchicalStreamReader, unmarshallingContext, treeMap, presortedMap);
            hierarchicalStreamReader.moveUp();
        }
        this.populateMap(hierarchicalStreamReader, unmarshallingContext, treeMap, presortedMap);
        try {
            if (JVM.hasOptimizedTreeMapPutAll()) {
                if (comparator != null && comparatorField != null) {
                    comparatorField.set(treeMap, comparator);
                }
                treeMap.putAll(presortedMap);
            } else if (comparatorField != null) {
                comparatorField.set(treeMap, presortedMap.comparator());
                treeMap.putAll(presortedMap);
                comparatorField.set(treeMap, comparator);
            } else {
                treeMap.putAll(presortedMap);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjectAccessException("Cannot set comparator of TreeMap", illegalAccessException);
        }
    }

    private static final class NullComparator
    extends Mapper.Null
    implements Comparator {
        private NullComparator() {
        }

        public int compare(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = (Comparable)object2;
            return comparable.compareTo(object2);
        }
    }
}

