/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.collections;

import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.CollectionConverter;
import zz.com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import zz.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.core.util.PresortedSet;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class TreeSetConverter
extends CollectionConverter {
    private transient TreeMapConverter treeMapConverter;
    private static final Field sortedMapField;
    private static final Object constantValue;

    public TreeSetConverter(Mapper mapper) {
        super(mapper, TreeSet.class);
        this.readResolve();
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        SortedSet sortedSet = (SortedSet)object;
        this.treeMapConverter.marshalComparator(sortedSet.comparator(), hierarchicalStreamWriter, marshallingContext);
        super.marshal(object, hierarchicalStreamWriter, marshallingContext);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        TreeMap treeMap;
        SortedSet sortedSet;
        Comparator comparator;
        TreeSet treeSet = null;
        Comparator comparator2 = this.treeMapConverter.unmarshalComparator(hierarchicalStreamReader, unmarshallingContext, null);
        boolean bl2 = comparator2 instanceof Mapper.Null;
        Comparator comparator3 = comparator = bl2 ? null : comparator2;
        if (sortedMapField != null) {
            sortedSet = comparator == null ? new TreeSet() : new TreeSet(comparator);
            Object object = null;
            try {
                object = sortedMapField.get(sortedSet);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectAccessException("Cannot get backing map of TreeSet", illegalAccessException);
            }
            if (object instanceof TreeMap) {
                treeMap = (TreeMap)object;
                treeSet = sortedSet;
            } else {
                treeMap = null;
            }
        } else {
            treeMap = null;
        }
        if (treeMap == null) {
            sortedSet = new PresortedSet(comparator);
            TreeSet treeSet2 = treeSet = comparator == null ? new TreeSet() : new TreeSet(comparator);
            if (bl2) {
                this.addCurrentElementToCollection(hierarchicalStreamReader, unmarshallingContext, treeSet, sortedSet);
                hierarchicalStreamReader.moveUp();
            }
            this.populateCollection(hierarchicalStreamReader, unmarshallingContext, treeSet, sortedSet);
            if (((PresortedSet)sortedSet).size() > 0) {
                treeSet.addAll(sortedSet);
            }
        } else {
            this.treeMapConverter.populateTreeMap(hierarchicalStreamReader, unmarshallingContext, treeMap, comparator2);
        }
        return treeSet;
    }

    private Object readResolve() {
        this.treeMapConverter = new TreeMapConverter(this.mapper()){

            protected void populateMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Map map, final Map map2) {
                TreeSetConverter.this.populateCollection(hierarchicalStreamReader, unmarshallingContext, new AbstractList(){

                    public boolean add(Object object) {
                        return map2.put(object, constantValue != null ? constantValue : object) != null;
                    }

                    public Object get(int n2) {
                        return null;
                    }

                    public int size() {
                        return map2.size();
                    }
                });
            }

            protected void putCurrentEntryIntoMap(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext, Map map, Map map2) {
                Object object = this.readItem(hierarchicalStreamReader, unmarshallingContext, map);
                map2.put(object, object);
            }
        };
        return this;
    }

    static {
        Object object = null;
        Field field = sortedMapField = JVM.hasOptimizedTreeSetAddAll() ? Fields.locate(TreeSet.class, SortedMap.class, false) : null;
        if (sortedMapField != null) {
            Object[] objectArray;
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.add("1");
            treeSet.add("2");
            Map map = null;
            try {
                map = (Map)sortedMapField.get(treeSet);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (map != null && (objectArray = map.values().toArray())[0] == objectArray[1]) {
                object = objectArray[0];
            }
        } else {
            Field field2 = Fields.locate(TreeSet.class, Object.class, true);
            if (field2 != null) {
                try {
                    object = field2.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        constantValue = object;
    }
}

