/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.enums;

import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class EnumConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.isEnum() || Enum.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.setValue(((Enum)object).name());
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Class clazz = unmarshallingContext.getRequiredType();
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        String string = hierarchicalStreamReader.getValue();
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                if (!enum_.name().equalsIgnoreCase(string)) continue;
                return enum_;
            }
            throw illegalArgumentException;
        }
    }
}

