/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.enums;

import java.lang.reflect.Field;
import java.util.EnumMap;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.converters.collections.MapConverter;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class EnumMapConverter
extends MapConverter {
    private static final Field typeField = Fields.locate(EnumMap.class, Class.class, false);

    public EnumMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class clazz) {
        return typeField != null && clazz == EnumMap.class;
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Class clazz = (Class)Fields.read(typeField, object);
        String string = this.mapper().aliasForSystemAttribute("enum-type");
        if (string != null) {
            hierarchicalStreamWriter.addAttribute(string, this.mapper().serializedClass(clazz));
        }
        super.marshal(object, hierarchicalStreamWriter, marshallingContext);
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = this.mapper().aliasForSystemAttribute("enum-type");
        if (string == null) {
            throw new ConversionException("No EnumType specified for EnumMap");
        }
        Class clazz = this.mapper().realClass(hierarchicalStreamReader.getAttribute(string));
        EnumMap enumMap = new EnumMap(clazz);
        this.populateMap(hierarchicalStreamReader, unmarshallingContext, enumMap);
        return enumMap;
    }
}

