/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.enums;

import java.lang.reflect.Field;
import java.util.EnumSet;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.Converter;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.UnmarshallingContext;
import zz.com.thoughtworks.xstream.core.util.Fields;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class EnumSetConverter
implements Converter {
    private static final Field typeField = Fields.locate(EnumSet.class, Class.class, false);
    private final Mapper mapper;

    public EnumSetConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class clazz) {
        return typeField != null && EnumSet.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        EnumSet enumSet = (EnumSet)object;
        Class clazz = (Class)Fields.read(typeField, enumSet);
        String string = this.mapper.aliasForSystemAttribute("enum-type");
        if (string != null) {
            hierarchicalStreamWriter.addAttribute(string, this.mapper.serializedClass(clazz));
        }
        hierarchicalStreamWriter.setValue(this.joinEnumValues(enumSet));
    }

    private String joinEnumValues(EnumSet enumSet) {
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (Enum enum_ : enumSet) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append(enum_.name());
        }
        return stringBuffer.toString();
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = this.mapper.aliasForSystemAttribute("enum-type");
        if (string == null) {
            throw new ConversionException("No EnumType specified for EnumSet");
        }
        Class clazz = this.mapper.realClass(hierarchicalStreamReader.getAttribute(string));
        EnumSet enumSet = EnumSet.noneOf(clazz);
        String[] stringArray = hierarchicalStreamReader.getValue().split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.length() <= 0) continue;
            enumSet.add(Enum.valueOf(clazz, string2));
        }
        return enumSet;
    }
}

