/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.enums;

import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSingleValueConverter
extends AbstractSingleValueConverter {
    private final Class<? extends Enum> enumType;

    public EnumSingleValueConverter(Class<? extends Enum> clazz) {
        if (!Enum.class.isAssignableFrom(clazz) && clazz != Enum.class) {
            throw new IllegalArgumentException("Converter can only handle defined enums");
        }
        this.enumType = clazz;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return this.enumType.isAssignableFrom(clazz);
    }

    @Override
    public String toString(Object object) {
        return ((Enum)Enum.class.cast(object)).name();
    }

    @Override
    public Object fromString(String string) {
        Enum enum_ = Enum.valueOf(this.enumType, string);
        return enum_;
    }
}

