/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.enums;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import zz.com.thoughtworks.xstream.InitializationException;
import zz.com.thoughtworks.xstream.converters.ConversionException;
import zz.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumToStringConverter<T extends Enum<T>>
extends AbstractSingleValueConverter {
    private final Class<T> enumType;
    private final Map<String, T> strings;
    private final EnumMap<T, String> values;

    public EnumToStringConverter(Class<T> clazz) {
        this(clazz, EnumToStringConverter.extractStringMap(clazz), null);
    }

    public EnumToStringConverter(Class<T> clazz, Map<String, T> map) {
        this(clazz, map, EnumToStringConverter.buildValueMap(clazz, map));
    }

    private EnumToStringConverter(Class<T> clazz, Map<String, T> map, EnumMap<T, String> enumMap) {
        this.enumType = clazz;
        this.strings = map;
        this.values = enumMap;
    }

    private static <T extends Enum<T>> Map<String, T> extractStringMap(Class<T> clazz) {
        EnumToStringConverter.checkType(clazz);
        EnumSet<Enum> enumSet = EnumSet.allOf(clazz);
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>(enumSet.size());
        for (Enum enum_ : enumSet) {
            if (hashMap.put(enum_.toString(), enum_) == null) continue;
            throw new InitializationException("Enum type " + clazz.getName() + " does not have unique string representations for its values");
        }
        return hashMap;
    }

    private static <T> void checkType(Class<T> clazz) {
        if (!Enum.class.isAssignableFrom(clazz) && clazz != Enum.class) {
            throw new InitializationException("Converter can only handle enum types");
        }
    }

    private static <T extends Enum<T>> EnumMap<T, String> buildValueMap(Class<T> clazz, Map<String, T> map) {
        EnumMap<T, String> enumMap = new EnumMap<T, String>(clazz);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            enumMap.put((Enum)entry.getValue(), entry.getKey());
        }
        return enumMap;
    }

    @Override
    public boolean canConvert(Class clazz) {
        return this.enumType.isAssignableFrom(clazz);
    }

    @Override
    public String toString(Object object) {
        Enum enum_ = (Enum)Enum.class.cast(object);
        return this.values == null ? enum_.toString() : this.values.get(enum_);
    }

    @Override
    public Object fromString(String string) {
        if (string == null) {
            return null;
        }
        Enum enum_ = (Enum)this.strings.get(string);
        if (enum_ == null) {
            ConversionException conversionException = new ConversionException("Invalid string representation for enum type");
            conversionException.add("enum-type", this.enumType.getName());
            conversionException.add("enum-string", string);
            throw conversionException;
        }
        return enum_;
    }
}

